Attribute VB_Name = "Module2"
'**********************************************************
' Enum Constant Value
'**********************************************************

'  RESULT OF FUNCTION
'
Public Enum ResultOfFunction

	QCAP_RS_SUCCESSFUL = &H0

	QCAP_RS_ERROR_GENERAL = &H1

	QCAP_RS_ERROR_OUT_OF_MEMORY = &H2

	QCAP_RS_ERROR_OUT_OF_RESOURCE = &H3

	QCAP_RS_ERROR_INVALID_DEVICE = &H4

	QCAP_RS_ERROR_INVALID_PARAMETER = &H5

	QCAP_RS_ERROR_NON_SUPPORT = &H6

	QCAP_RS_ERROR_TIMEOUT = &H7

    QCAP_RS_ERROR_INVALID_ANIMATION_SCRIPT = &H8

    QCAP_RS_ERROR_NO_SIGNAL_DETECTED = &H9

    QCAP_RS_ERROR_NEED_MORE_DATA = &HA

    QCAP_RS_ERROR_CONNECT_FAIL = &HB
    
End Enum

' RETURN OF CALLBACK
'
Public Enum ReturnOfCallbackEnum

	QCAP_RT_OK = &H0

	QCAP_RT_FAIL = &H1

	QCAP_RT_SKIP_RECORD_NUM_00 = &H10002

	QCAP_RT_SKIP_RECORD_NUM_01 = &H20002

	QCAP_RT_SKIP_RECORD_NUM_02 = &H40002

	QCAP_RT_SKIP_RECORD_NUM_03 = &H80002

	QCAP_RT_SKIP_DISPLAY = &H4

	QCAP_RT_SKIP_CLONE_DISPLAY = &H8

	QCAP_RT_RESET_RECORD_NUM_00 = &H1000010

	QCAP_RT_RESET_RECORD_NUM_01 = &H2000010

	QCAP_RT_RESET_RECORD_NUM_02 = &H4000010

	QCAP_RT_RESET_RECORD_NUM_03 = &H8000010
                
End Enum

' DEVICE ENUMERATION TYPE
'
Public Enum DeviceEnumerationTypeEnum

	QCAP_ENUM_TYPE_DEVICE_NAME = &H0

	QCAP_ENUM_TYPE_SERIAL_NUMBER = &H1

End Enum
        
' INPUT VIDEO SOURCE
'
Public Enum InputVideoSourceEnum

	QCAP_INPUT_TYPE_COMPOSITE = 0

	QCAP_INPUT_TYPE_SVIDEO = 1

	QCAP_INPUT_TYPE_HDMI = 2

	QCAP_INPUT_TYPE_DVI_D = 3

	QCAP_INPUT_TYPE_COMPONENTS = 4

	QCAP_INPUT_TYPE_YCBCR = 4

	QCAP_INPUT_TYPE_DVI_A = 5

	QCAP_INPUT_TYPE_RGB = 5

	QCAP_INPUT_TYPE_VGA = 5

    QCAP_INPUT_TYPE_SDI = 6

    QCAP_INPUT_TYPE_DISPLAY_PORT = 8

	QCAP_INPUT_TYPE_AUTO = 7

End Enum

' INPUT AUDIO SOURCE
'
Public Enum InputAudioSourceEnum

	QCAP_INPUT_TYPE_EMBEDDED_AUDIO = 0

	QCAP_INPUT_TYPE_LINE_IN = 1

	QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE = 2

	QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN = 3

End Enum

' VIDEO STANDARD TYPE
'
Public Enum VideoStandardTypeEnum

	QCAP_STANDARD_TYPE_NTSC_M = &H1

	QCAP_STANDARD_TYPE_NTSC_M_J = &H2

	QCAP_STANDARD_TYPE_NTSC_433 = &H4

	QCAP_STANDARD_TYPE_PAL_M = &H200

	QCAP_STANDARD_TYPE_PAL_60 = &H800

	QCAP_STANDARD_TYPE_PAL_B = &H10

	QCAP_STANDARD_TYPE_PAL_D = &H20

	QCAP_STANDARD_TYPE_PAL_G = &H40

	QCAP_STANDARD_TYPE_PAL_H = &H80

	QCAP_STANDARD_TYPE_PAL_I = &H100

	QCAP_STANDARD_TYPE_PAL_N = &H400

	QCAP_STANDARD_TYPE_PAL_N_COMBO = &H100000

	QCAP_STANDARD_TYPE_AUTO = &H80000000

End Enum

' VIDEO DEINTERLACE TYPE
'
Public Enum SoftwareDeinterlaceTypeEnum

	QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING = &H0 ' DEFAULT

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE = &H1

	QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE = &H2

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MEDICAL_FILTER = &H3

End Enum

' COLORSPACE TYPE
'
Public Enum ColorSpaceTypeEnum

	QCAP_COLORSPACE_TYEP_RGB24 = 0 ' 0xRRGGBB

	QCAP_COLORSPACE_TYEP_BGR24 = 1 ' 0xBBGGRR

	QCAP_COLORSPACE_TYEP_ARGB32 = 2 ' 0xAARRGGBB

	QCAP_COLORSPACE_TYEP_ABGR32 = 3 ' 0xAABBGGRR

	QCAP_COLORSPACE_TYEP_YUY2 = &H32595559 'MAKEFOURCC('Y', 'U', 'Y', '2')

	QCAP_COLORSPACE_TYEP_UYVY = &H59565955 'MAKEFOURCC('U', 'Y', 'V', 'Y')

	QCAP_COLORSPACE_TYEP_YV12 = &H32315659 'MAKEFOURCC('Y', 'V', '1', '2')

	QCAP_COLORSPACE_TYEP_I420 = &H30323449 ' 0x30323449 -> MAKEFOURCC('I', '4', '2', '0')

	QCAP_COLORSPACE_TYEP_H264 = &H34363248 ' 0x34363248 -> MAKEFOURCC('H', '2', '6', '4')

End Enum

' ENCODER TYPE (RECORD PROPERTY)
'
Public Enum EncoderTypeEnum

	QCAP_ENCODER_TYPE_SOFTWARE = 0

	QCAP_ENCODER_TYPE_HARDWARE = 1 ' IT IS ONLY USED FOR HARDWARE COMPRESSION CAPTURE CARD, SUCH AS SC580 & SC590

	QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK = 2

	QCAP_ENCODER_TYPE_AMD_STREAM = 3

	QCAP_ENCODER_TYPE_NVIDIA_CUDA = 4

    QCAP_ENCODER_TYPE_NVIDIA_NVENC = 5 ' DEVELOPING ...

End Enum

' ENCODER VIDEO FORMAT (RECORD PROPERTY)
'
Public Enum VideoEncoderFormatEnum

	QCAP_ENCODER_FORMAT_MPEG2 = 1

	QCAP_ENCODER_FORMAT_H264 = 0

    QCAP_ENCODER_FORMAT_H264_3D = 2

    QCAP_ENCODER_FORMAT_H264_VC = 3

    QCAP_ENCODER_FORMAT_RAW = 4
    
End Enum

' ENCODER AUDIO FORMAT (RECORD PROPERTY)
'
Public Enum AudioEncoderFormatEnum

	QCAP_ENCODER_FORMAT_PCM = 0

	QCAP_ENCODER_FORMAT_AAC = 1

	QCAP_ENCODER_FORMAT_AAC_RAW = 1

	QCAP_ENCODER_FORMAT_AAC_ADTS = 2

End Enum

' RECORD PROFILE (RECORD PROPERTY)
'
Public Enum RecordProfileEnum

	QCAP_RECORD_PROFILE_BASELINE = 0

	QCAP_RECORD_PROFILE_MAIN = 1

    QCAP_RECORD_PROFILE_HIGH = 2

    QCAP_RECORD_PROFILE_CONSTRAINED_BASELINE = 3

    QCAP_RECORD_PROFILE_CONSTRAINED_HIGH = 4

End Enum
        
' RECORD LEVEL (RECORD PROPERTY)
'
Public Enum RecordLevelEnum

	QCAP_RECORD_LEVEL_1 = 10

	QCAP_RECORD_LEVEL_1B = 9

	QCAP_RECORD_LEVEL_11 = 11

	QCAP_RECORD_LEVEL_12 = 12

	QCAP_RECORD_LEVEL_13 = 13

	QCAP_RECORD_LEVEL_2 = 20

	QCAP_RECORD_LEVEL_21 = 21

	QCAP_RECORD_LEVEL_22 = 22

	QCAP_RECORD_LEVEL_3 = 30

	QCAP_RECORD_LEVEL_31 = 31

	QCAP_RECORD_LEVEL_32 = 32

	QCAP_RECORD_LEVEL_4 = 40

	QCAP_RECORD_LEVEL_41 = 41

	QCAP_RECORD_LEVEL_42 = 42

	QCAP_RECORD_LEVEL_50 = 50

	QCAP_RECORD_LEVEL_51 = 51

	QCAP_RECORD_LEVEL_52 = 52

End Enum

' RECORD ENTROPY (RECORD PROPERTY)
'
Public Enum RecordEntropyEnum

	QCAP_RECORD_ENTROPY_CAVLC = 0

	QCAP_RECORD_ENTROPY_CABAC = 1

End Enum

' RECORD COMPLEXITY (RECORD PROPERTY)
'
Public Enum RecordComplexityEnum

	QCAP_RECORD_COMPLEXITY_0 = 0

	QCAP_RECORD_COMPLEXITY_1 = 1

	QCAP_RECORD_COMPLEXITY_2 = 2

	QCAP_RECORD_COMPLEXITY_3 = 3

	QCAP_RECORD_COMPLEXITY_4 = 4

	QCAP_RECORD_COMPLEXITY_5 = 5

	QCAP_RECORD_COMPLEXITY_6 = 6

End Enum
        
' RECORD MODE (RECORD PROPERTY)
'
Public Enum RecordModeEnum

	QCAP_RECORD_MODE_VBR = 0

	QCAP_RECORD_MODE_CBR = 1

    QCAP_RECORD_MODE_ABR = 2

    QCAP_RECORD_MODE_CQP = 3

End Enum

' DOWNSCALE MODE (RECORD PROPERTY)
'
Public Enum DownScaleModeEnum

	QCAP_DOWNSCALE_MODE_OFF = 0 ' (1920, 1080) * (1 / 1) = (1920, 1080)

	QCAP_DOWNSCALE_MODE_2_3 = 1 ' (1920, 1080) * (2 / 3) = (1280,  720)

	QCAP_DOWNSCALE_MODE_1_2 = 2 ' (1920, 1080) * (1 / 2) = ( 960,  480)

	QCAP_DOWNSCALE_MODE_1_4 = 3 ' (1920, 1080) * (1 / 4) = ( 480,  240)

End Enum

' RECORD FLAG (RECORD PROPERTY)
'
Public Enum RecordFlagEnum

	QCAP_RECORD_FLAG_FULL = &H7

	QCAP_RECORD_FLAG_FILE = &H1

	QCAP_RECORD_FLAG_ENCODE = &H2

	QCAP_RECORD_FLAG_DISPLAY = &H4

	QCAP_RECORD_FLAG_DECODE = &H8

	QCAP_RECORD_FLAG_VIDEO_ONLY = &H10

    QCAP_RECORD_FLAG_AUDIO_ONLY = &H20

    QCAP_RECORD_FLAG_VIDEO_USE_IDEAL_TIMESTAMP = &H40

    QCAP_RECORD_FLAG_AUDIO_USE_IDEAL_TIMESTAMP = &H80

	QCAP_RECORD_FLAG_INGNORE_FORMAT_CHANGED = &H100

End Enum

' BROADCAST FLAG (BROADCAST PROPERTY)
'
Public Enum BroadCastFlagEnum

	QCAP_BROADCAST_FLAG_FULL = &H7

	QCAP_BROADCAST_FLAG_NETWORK = &H1

	QCAP_BROADCAST_FLAG_ENCODE = &H2

	QCAP_BROADCAST_FLAG_DISPLAY = &H4

    QCAP_BROADCAST_FLAG_DECODE = &H8

    QCAP_BROADCAST_FLAG_VIDEO_ONLY = &H10

    QCAP_BROADCAST_FLAG_AUDIO_ONLY = &H20

End Enum

' BROADCAST CONNECTION TYPE (BROADCAST PROPERTY)
'
Public Enum BroadCastConnectionTypeEnum

	QCAP_BROADCAST_PROTOCOL_UDP = &H0

	QCAP_BROADCAST_PROTOCOL_TCP = &H1

	QCAP_BROADCAST_PROTOCOL_HTTP = &H2

End Enum

' FONT STYLE
'
Public Enum FontStyleEnum

	QCAP_FONT_STYLE_REGULAR = &H0

	QCAP_FONT_STYLE_BOLD = &H1

	QCAP_FONT_STYLE_ITALIC = &H2

	QCAP_FONT_STYLE_BOLDITALIC = &H3

	QCAP_FONT_STYLE_UNDERLINE = &H4

	QCAP_FONT_STYLE_STRIKEOUT = &H8

End Enum

' OSD SEQUENCE STYLE (OSD PROPERTY)
'
Public Enum SequenceStyleEnum

	QCAP_SEQUENCE_STYLE_FOREMOST = &H0

	QCAP_SEQUENCE_STYLE_BEFORE_ENCODE = &H1

	QCAP_SEQUENCE_STYLE_AFTERMOST = &H2

End Enum

' DECODER TYPE (PLAYBACK PROPERTY)
'
Public Enum DecoderTypeEnum

	QCAP_DECODER_TYPE_SOFTWARE = 0

	QCAP_DECODER_TYPE_HARDWARE = 1

	QCAP_DECODER_TYPE_INTEL_MEDIA_SDK = 2

	QCAP_DECODER_TYPE_AMD_STREAM = 3

	QCAP_DECODER_TYPE_NVIDIA_CUDA = 4
	
	QCAP_DECODER_TYPE_NVIDIA_NVENC = 5

End Enum

' 3D STEREO BUFFER TYPE
'
Public Enum StereoBufferTypeEnum

    QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE = &H0

    QCAP_3D_STEREO_BUFFER_TOP_BOTTOM = &H1

    QCAP_3D_STEREO_BUFFER_LINE_BY_LINE = &H2

End Enum

' 3D STEREO DISPLAY MODE
'
Public Enum StereoDisplayModeEnum

    QCAP_3D_STEREO_DISPLAY_MODE_SIDE_BY_SIDE = &H0

    QCAP_3D_STEREO_DISPLAY_MODE_TOP_BOTTOM = &H1

    QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE = &H2

    QCAP_3D_STEREO_DISPLAY_MODE_LEFT_ONLY = &H3

    QCAP_3D_STEREO_DISPLAY_MODE_RIGHT_ONLY = &H4

End Enum

Public Declare Sub PF_FORMAT_ Lib "QCAP.DLL" (ByVal pFunc As Long)

' CALLBACK FUNCTION TYPES
'
Public Declare Function PF_NO_SIGNAL_DETECTED_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum  'COMMON VARIABLES

Public Declare Function PF_SIGNAL_REMOVED_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_FORMAT_CHANGED_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nVideoInput As Long, ByVal nAudioInput As Long, ByVal nVideoWidth As Long, ByVal nVideoHeight As Long, ByVal bVideoIsInterleaved As Long, ByVal dVideoFrameRate As Double, ByVal nAudioChannels As Long, ByVal nAudioBitsPerSample As Long, ByVal nAudioSampleFrequency As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_RECORD_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_SHARE_RECORD_DONE_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszProperty As String, ByRef pszValue As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszProperty As String, ByVal pszValue As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_CLIENT_CONNECTED_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal nVideoWidth As Long, ByVal nVideoHeight As Long, ByVal bVideoIsInterleaved As Boolean, ByVal dVideoFrameRate As Double, ByVal nAudioChannels As Long, ByVal nAudioBitsPerSample As Long, ByVal nAudioSampleFrequency As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iProNum As Long, ByVal nEncoderFormat As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal nFrameRate As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iProNum As Long, ByVal nEncoderFormat As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nBitRate As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_FILE_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_FILE_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_PREVIEW_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_PREVIEW_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_HARDWARE_ENCODER_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_MEDIA_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_MX_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_MEDIA_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Boolean, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iChNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_DECODER_FILE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_VIDEO_DECODER_3D_FILE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iChNum As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

Public Declare Function PF_AUDIO_DECODER_FILE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal dSampleTime As Double, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal pUserData As Long) As ReturnOfCallbackEnum 'COMMON VARIABLES

' SYSTEM FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_GET_VERSION Lib "QCAP.DLL" (ByRef pMajorVersion As Long, ByRef pMinorVersion As Long) As ResultOfFunction

Public Declare Function QCAP_SET_SYSTEM_CONFIGURATION Lib "QCAP.DLL" (Optional ByVal bEnableMultipleUsersAccess As Boolean = 1, Optional ByVal bEnableVideoPreviewDevice As Boolean = 1, Optional ByVal bEnableAudioPreviewDevice As Boolean = 1, Optional ByVal bEnableVideoHardwareMainEncoderDevice As Boolean = 1, Optional ByVal bEnableVideoHardwareSubEncoderDevice As Boolean = 1, Optional ByVal nAutoInputDetectionTimeout As Long = 3000, Optional ByVal bEnableSCF As Boolean = 0, Optional ByVal pszDB3 As String = "", Optional ByVal bEnableAsyncBackgroundSnapshot As Boolean = 0, Optional ByVal bEnableEnhancedVideoRenderer As Boolean = 1, Optional ByVal bEnableSystemTimeCallback As Boolean = 0, Optional ByVal bEnableFileRepairFunction As Boolean = 1, Optional ByVal bEnableNewRTSPLibrary As Boolean = 1, Optional ByVal pszWebServerRootFolderPath As String = "", Optional ByVal pszWebServerIP As String = "") As ResultOfFunction

Public Declare Function QCAP_QUERY_ENCODER_TYPE_CAP Lib "QCAP.DLL" (ByVal nEncoderType As Long) As ResultOfFunction

Public Declare Function QCAP_QUERY_DECODER_TYPE_CAP Lib "QCAP.DLL" (ByVal nDecoderType As Long) As ResultOfFunction

Public Declare Function QCAP_QUERY_ENCODER_STATUS Lib "QCAP.DLL" (ByVal nEncoderType As Long, ByRef pExistInstances As Long) As ResultOfFunction

' DEVICE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_DEVICE_ENUMERATION Lib "QCAP.DLL" (ByRef ppVideoDeviceList As Long, ByRef pVideoDeviceSize As Long, ByRef ppVideoEncoderDeviceList As Long, ByRef pVideoEncoderDeviceSize As Long, ByRef ppAudioDeviceList As Long, ByRef pAudioDeviceSize As Long, ByRef ppAudioEncoderDeviceList As Long, ByRef pAudioEncoderDeviceSize As Long, Optional ByVal nDeviceEnumType As Long = QCAP_ENUM_TYPE_DEVICE_NAME) As ResultOfFunction

Public Declare Function QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO Lib "QCAP.DLL" (ByVal iDevNum As Long, ByVal pDeviceList As Long, ByRef pDeviceInfoH As Long, ByRef pDeviceInfoL As Long) As ResultOfFunction

Public Declare Function QCAP_CREATE Lib "QCAP.DLL" (ByVal pszDevName As String, ByVal iDevNum As Long, ByVal hAttachedWindow As Long, ByRef ppDevice As Long, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_DESTROY Lib "QCAP.DLL" (ByVal pDevice As Long) As ResultOfFunction

Public Declare Function QCAP_RUN Lib "QCAP.DLL" (ByVal pDevice As Long) As ResultOfFunction

Public Declare Function QCAP_STOP Lib "QCAP.DLL" (ByVal pDevice As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_INPUT Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pInput As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_INPUT Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nInput As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_INPUT Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pInput As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_INPUT Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nInput As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_STANDARD Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pStandard As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_STANDARD Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nStandard As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pIsInterleaved As Boolean, ByRef pFrameRate As Double) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pIsInterleaved As Boolean, ByRef pFrameRate As Double) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bIsInterleaved As Boolean, ByVal dFrameRate As Double) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_DEINTERLACE_TYPE Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pType As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_DEINTERLACE_TYPE Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nType As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_DEINTERLACE Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pEnable As Boolean) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_DEINTERLACE Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nEnable As Boolean) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_REGION_DISPLAY Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_REGION_DISPLAY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_MIRROR Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pHorizontalMirror As Boolean, ByRef pVerticalMirror As Boolean) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_MIRROR Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror As Boolean) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_BRIGHTNESS Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BRIGHTNESS Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_CONTRAST Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_CONTRAST Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_HUE Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_HUE Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_SATURATION Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SATURATION Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_SHARPNESS Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARPNESS Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pDownscaleMode As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nDownscaleMode As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderFormat As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pDownscaleMode As Long, ByRef pPostSkipFrameRate As Long, ByRef pPostAvgFrameRate As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nEncoderFormat As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, ByVal nDownscaleMode As Long, ByVal nPostSkipFrameRate As Long, ByVal nPostAvgFrameRate As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderFormat As Long, ByRef pRecordProfile As Long, ByRef pRecordLevel As Long, ByRef pRecordEntropy As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames As Long, ByRef pIsInterleaved As Boolean, ByRef pSlices As Long, ByRef pLayers As Long, ByRef pSceneCut As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long, ByRef pDownscaleMode As Long, ByRef pPostSkipFrameRate As Long, ByRef pPostAvgFrameRate As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nEncoderFormat As Long, ByVal nRecordProfile As Long, ByVal nRecordLevel As Long, ByVal nRecordEntropy As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nBFrames As Long, ByVal bIsInterleaved As Boolean, ByVal nSlices As Long, ByVal nLayers As Long, ByVal nSceneCut As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDownscaleMode As Long, ByVal nPostSkipFrameRate As Long, ByVal nPostAvgFrameRate As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nProperty As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nProperty As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_VOLUME Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_VOLUME Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_GET_DEVICE_CUSTOM_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByRef pValue As Long) As ResultOfFunction

Public Declare Function QCAP_SET_DEVICE_CUSTOM_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByVal nValue As Long) As ResultOfFunction

Public Declare Function QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByVal pValue As Long, ByVal nBytes As Long) As ResultOfFunction

Public Declare Function QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal nProperty As Long, ByVal pValue As Long, ByVal nBytes As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_FORMAT_CHANGED_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_RECORD_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

' CALLBACK FUNCTIONS PART.II
'
Public Declare Function QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

' CALLBACK FUNCTIONS PART.III
'
Public Declare Function QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

' CALLBACK FUNCTIONS PART.IIII
'
Public Declare Function QCAP_REGISTER_VIDEO_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_MEDIA_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

Public Declare Function QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pCB As Long, ByVal pUserData As Long) As ResultOfFunction

' LOCK/UNLOCK FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_COPY_VIDEO_PREVIEW_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double, ByVal pFrameBuffer As Long, ByRef pFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_COPY_AUDIO_PREVIEW_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double, ByVal pFrameBuffer As Long, ByRef pFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_LOCK_VIDEO_PREVIEW_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double, ByRef ppFrameBuffer As Long, ByRef pFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long) As ResultOfFunction

Public Declare Function QCAP_LOCK_AUDIO_PREVIEW_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long, ByRef pSampleTime As Double, ByRef ppFrameBuffer As Long, ByRef pFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long) As ResultOfFunction

' SNAPSHOT FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_SNAPSHOT_BMP Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_JPG Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BMP_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_JPG_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

' CHANNEL RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS CHANNEL RECORDING) (RECNUM: 0 ~ 3) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_GET_VIDEO_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pDownscaleMode As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, ByVal nDownscaleMode As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pRecordProfile As Long, ByRef pRecordLevel As Long, ByRef pRecordEntropy As Long, ByRef pRecordComplexity As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames As Long, ByRef pIsInterleaved As Boolean, ByRef pSlices As Long, ByRef pLayers As Long, ByRef pSceneCut As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long, ByRef pDstW As Long, ByRef pDstH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nRecordProfile As Long, ByVal nRecordLevel As Long, ByVal nRecordEntropy As Long, ByVal nRecordComplexity As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nBFrames As Long, ByVal bIsInterleaved As Boolean, ByVal nSlices As Long, ByVal nLayers As Long, ByVal nSceneCut As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pBitRate As Long, ByRef pEncoderFormat As Long, ByRef pBitRate As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nBitRate As Long, ByVal nEncoderFormat As Long, ByVal nBitRate As Long) As ResultOfFunction

Public Declare Function QCAP_START_CLONE_RECORD Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathNameA As String, ByVal pszFilePathNameB As String, Optional ByVal dwFlags As Long = &H7, Optional ByVal dVideoDelayTime As Double = 0.0#, Optional ByVal dAudioDelayTime As Double = 0.0#, Optional ByVal dSegmentDurationTime As Double = 0.0#, Optional ByVal nSegmentDurationSizeKB As Long = 0) As ResultOfFunction

Public Declare Function QCAP_START_RECORD Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, ByVal pszFilePathName As String, Optional ByVal dwFlags As Long = &H7, Optional ByVal dVideoDelayTime As Double = 0.0#, Optional ByVal dAudioDelayTime As Double = 0.0#, Optional ByVal dSegmentDurationTime As Double = 0.0#, Optional ByVal nSegmentDurationSizeKB As Long = 0) As ResultOfFunction

Public Declare Function QCAP_STOP_RECORD Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_RESUME_RECORD Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_RECORD Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iRecNum As Long) As ResultOfFunction

' CLONE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_CREATE_CLONE Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal hAttachedWindow As Long, ByRef ppCloneDevice As Long, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0) As ResultOfFunction

' OSD FUNCTIONS (SUPPORT MULTIPLE-LAYERS OSD OBJECTS) (OSDNUM: 0 ~ 15) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_GET_OSD_TEXT_BOUNDARY Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight As Long) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_TEXT Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, Optional ByVal nTextStartPosX As Long = 0, Optional ByVal nTextStartPosY As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_PICTURE Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BUFFER Lib "QCAP.DLL" (ByVal pDevice As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, Optional ByVal dwKeyColor As Long = &H0, Optional ByVal nKeyColorThreshold As Long = 25, Optional ByVal pMaskBuffer As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

' SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 15) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, Optional ByRef pAttachedWindow As Long = 0, Optional ByRef pThumbDraw As Boolean = 0, Optional ByRef pMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dFrameRate As Double, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, Optional ByVal pAttachedWindow As Long = 0, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordProfile As Long, ByRef pRecordLevel As Long, ByRef pRecordEntropy As Long, ByRef pRecordComplexity As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames As Long, ByRef pIsInterleaved As Boolean, ByRef pSlices As Long, ByRef pLayers As Long, ByRef pSceneCut As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, Optional ByRef pAttachedWindow As Long = 0, Optional ByRef pThumbDraw As Boolean = 0, Optional ByRef pMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dFrameRate As Double, ByVal nRecordProfile As Long, ByVal nRecordLevel As Long, ByVal nRecordEntropy As Long, ByVal nRecordComplexity As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nBFrames As Long, ByVal bIsInterleaved As Boolean, ByVal nSlices As Long, ByVal nLayers As Long, ByVal nSceneCut As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, Optional ByVal pAttachedWindow As Long = 0, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nBitRate As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal bForceKeyFrame As Boolean = 0, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_START_SHARE_RECORD Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, Optional ByVal dwFlags As Long = &H7, Optional ByVal dVideoDelayTime As Double = 0.0#, Optional ByVal dAudioDelayTime As Double = 0.0#, Optional ByVal dSegmentDurationTime As Double = 0.0#, Optional ByVal nSegmentDurationSizeKB As Long = 0) As ResultOfFunction

Public Declare Function QCAP_STOP_SHARE_RECORD Lib "QCAP.DLL" (ByVal iRecNum As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_RESUME_SHARE_RECORD Lib "QCAP.DLL" (ByVal iRecNum As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SHARE_RECORD Lib "QCAP.DLL" (ByVal iRecNum As Long) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_BMP Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_JPG Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight As Long) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_SHARE_RECORD_TEXT Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, Optional ByVal nTextStartPosX As Long = 0, Optional ByVal nTextStartPosY As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_SHARE_RECORD_PICTURE Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_SHARE_RECORD_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, Optional ByVal dwKeyColor As Long = &H0, Optional ByVal nKeyColorThreshold As Long = 25, Optional ByVal pMaskBuffer As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

' 3D SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS 3D SHARE RECORDING) (RECNUM: 0 ~ 15) //////////////////////////////////////////////////////////////////////////////////////////////
' 
Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal nStereoBufferType As Long = StereoBufferTypeEnum.QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal nStereoBufferType As Long = StereoBufferTypeEnum.QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, Optional ByVal nStereoDisplayMode As Long = StereoDisplayModeEnum.QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE, Optional ByVal bLeftRightSwap As Boolean = 0, Optional ByVal bForceKeyFrame As Boolean = 0, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

' AUDIO MIXING SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 15) ///////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByRef pTracks As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal nTracks As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nBitRate As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal iTrackNum As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal iRecNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

' BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS)
'
Public Declare Function QCAP_CREATE_BROADCAST_RTSP_SERVER Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, Optional ByVal pszAccount As String = "", Optional ByVal pszPassword As String = "", Optional ByVal nNetworkPort_RTSP As Long = 554, Optional ByVal nNetworkPort_RTSPOverHTTP As Long = 0, Optional ByVal bEnableMulticasting As Boolean = False) As ResultOfFunction  ' nNetworkPort_RTSPOverHTTP : IN 0 = TURN OFF

Public Declare Function QCAP_CREATE_BROADCAST_RTMP_SERVER Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, Optional ByVal pszAccount As String = "", Optional ByVal pszPassword As String = "", Optional ByVal nNetworkPort_RTMP As Long = 1935, Optional ByVal nNetworkPort_RTMPOverHTTP As Long = 0, Optional ByVal pszServerName As String = "") As ResultOfFunction ' nNetworkPort_RTMPOverHTTP : IN 0 = TURN OFF

Public Declare Function QCAP_CREATE_BROADCAST_RTMP_SERVER_EX Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, Optional ByVal pszAccount As String = "", Optional ByVal pszPassword As String = "", Optional ByVal nNetworkPort_RTMP As Long = 1935, Optional ByVal nNetworkPort_RTMPOverHTTP As Long = 0, Optional ByVal pszServerName As String = "") As ResultOfFunction ' nNetworkPort_RTMPOverHTTP : IN 0 = TURN OFF

Public Declare Function QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal pszURL As String, ByRef ppServer As Long, Optional ByVal pszAccount As String = "", Optional ByVal pszPassword As String = "") As ResultOfFunction ' TOTOAL SESSION = 1

Public Declare Function QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal pszURL As String, ByRef ppServer As Long, Optional ByVal pszAccount As String = "", Optional ByVal pszPassword As String = "") As ResultOfFunction ' TOTOAL SESSION = 1

Public Declare Function QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal pszURL As String, ByRef ppServer As Long, Optional ByVal pszAccount As String = "", Optional ByVal pszPassword As String = "") As ResultOfFunction ' TOTOAL SESSION = 1

Public Declare Function QCAP_CREATE_BROADCAST_HLS_SERVER Lib "QCAP.DLL" (ByVal iSvrNum As Long, ByVal nTotalSessions As Long, ByRef ppServer As Long, ByVal pszWebServerRootFolderPath As String, ByVal pszSubFolderPath As String, Optional ByVal nSegmentDuration As Long = 1000, Optional ByVal pszWebServerIP As String = "") As ResultOfFunction

Public Declare Function QCAP_DESTROY_BROADCAST_SERVER Lib "QCAP.DLL" (ByVal pServer As Long) As ResultOfFunction

Public Declare Function QCAP_START_BROADCAST_SERVER Lib "QCAP.DLL" (ByVal pServer As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_BROADCAST_SERVER Lib "QCAP.DLL" (ByVal pServer As Long) As ResultOfFunction

Public Declare Function QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef ppszSessionName As String, ByRef pVideoDelayLiveDuration As Long, ByRef pAudioDelayLiveDuration As Long) As ResultOfFunction

Public Declare Function QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszSessionName As String, ByVal nVideoDelayLiveDuration As Long, ByVal nAudioDelayLiveDuration As Long) As ResultOfFunction

Public Declare Function QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pDevice As Long, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pDevice As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, Optional ByRef pAttachedWindow As Long = 0, Optional ByRef pThumbDraw As Boolean = 0, Optional ByRef pMaintainAspectRatio As Boolean = 0, Optional ByRef pFlags As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dFrameRate As Double, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, Optional ByVal hAttachedWindow As Long = 0, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0, Optional ByVal dwFlags As Long = BroadCastFlagEnum.QCAP_BROADCAST_FLAG_FULL) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double, ByRef pRecordProfile As Long, ByRef pRecordLevel As Long, ByRef pRecordEntropy As Long, ByRef pRecordComplexity As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long, ByRef pBFrames As Long, ByRef pIsInterleaved As Boolean, ByRef pSlices As Long, ByRef pLayers As Long, ByRef pSceneCut As Long, ByRef pAspectRatioX As Long, ByRef pAspectRatioY As Long, Optional ByRef pAttachedWindow As Long = 0, Optional ByRef pThumbDraw As Boolean = 0, Optional ByRef pMaintainAspectRatio As Boolean = 0, Optional ByRef pFlags As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dFrameRate As Double, ByVal nRecordProfile As Long, ByVal nRecordLevel As Long, ByVal nRecordEntropy As Long, ByVal nRecordComplexity As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long, ByVal nBFrames As Long, ByVal bIsInterleaved As Boolean, ByVal nSlices As Long, ByVal nLayers As Long, ByVal nSceneCut As Long, ByVal nAspectRatioX As Long, ByVal nAspectRatioY As Long, Optional ByVal hAttachedWindow As Long = 0, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0, Optional ByVal dwFlags As Long = BroadCastFlagEnum.QCAP_BROADCAST_FLAG_FULL) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pRecordMode As Long, ByRef pQuality As Long, ByRef pBitRate As Long, ByRef pGOP As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nRecordMode As Long, ByVal nQuality As Long, ByVal nBitRate As Long, ByVal nGOP As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByRef pEncoderType As Long, ByRef pEncoderFormat As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long, ByRef pBitRate As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nEncoderType As Long, ByVal nEncoderFormat As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal nBitRate As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal bForceKeyFrame As Boolean = 0, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByVal bIsKeyFrame As Long, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_SERVER_BMP Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_SERVER_JPG Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight As Long) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BROADCAST_SERVER_TEXT Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, Optional ByVal nTextStartPosX As Long = 0, Optional ByVal nTextStartPosY As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BROADCAST_SERVER_PICTURE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BROADCAST_SERVER_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, Optional ByVal dwKeyColor As Long = &H0, Optional ByVal nKeyColorThreshold As Long = 25, Optional ByVal pMaskBuffer As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

' 3D BROADCASTING SERVER FUNCTIONS (3D SHARE STREAMING TX FUNCTIONS)
' 
Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal nStereoBufferType As Long = StereoBufferTypeEnum.QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal nStereoBufferType As Long = StereoBufferTypeEnum.QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, Optional ByVal nStereoDisplayMode As Long = StereoDisplayModeEnum.QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE, Optional ByVal bLeftRightSwap As Boolean = 0, Optional ByVal bForceKeyFrame As Boolean = 0, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

' AUDIO MIXING BROADCASTING SERVER FUNCTIONS
'
Public Declare Function QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iSessionNum As Long, Optional ByVal dSampleTime As Double = 0.0#, Optional ByVal bClearDelayLive As Boolean = 0) As ResultOfFunction

' BROADCASTING CLIENT FUNCTIONS (SHARE STREAMING RX FUNCTIONS)
'
Public Declare Function QCAP_CREATE_BROADCAST_CLIENT Lib "QCAP.DLL" (ByVal iCliNum As Long, ByVal pszURL As String, ByRef ppClient As Long, ByVal nDecoderType As Long, Optional ByVal hAttachedWindow As Long = 0, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_DESTROY_BROADCAST_CLIENT Lib "QCAP.DLL" (ByVal pClient As Long) As ResultOfFunction

Public Declare Function QCAP_START_BROADCAST_CLIENT Lib "QCAP.DLL" (ByVal pClient As Long, Optional ByVal nProtocol As Long = BroadCastConnectionTypeEnum.QCAP_BROADCAST_PROTOCOL_UDP, Optional ByVal nReconnectionTimeout As Long = 3000, Optional ByVal nDelayQueueDuration As Long = 3000) As ResultOfFunction

Public Declare Function QCAP_STOP_BROADCAST_CLIENT Lib "QCAP.DLL" (ByVal pClient As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY Lib "QCAP.DLL" (ByVal pClient As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY Lib "QCAP.DLL" (ByVal pClient As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR Lib "QCAP.DLL" (ByVal pClient As Long, ByRef pHorizontalMirror As Boolean, ByRef pVerticalMirror As Boolean) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR Lib "QCAP.DLL" (ByVal pClient As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror As Boolean) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME Lib "QCAP.DLL" (ByVal pClient As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME Lib "QCAP.DLL" (ByVal pClient As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_START_BROADCAST_CLIENT_RECORD Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, Optional ByVal dVideoDelayTime As Double = 0.0#, Optional ByVal dAudioDelayTime As Double = 0.0#, Optional ByVal dSegmentDurationTime As Double = 0.0#, Optional ByVal nSegmentDurationSizeKB As Long = 0) As ResultOfFunction

Public Declare Function QCAP_STOP_BROADCAST_CLIENT_RECORD Lib "QCAP.DLL" (ByVal pClient As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_RESUME_BROADCAST_CLIENT_RECORD Lib "QCAP.DLL" (ByVal pClient As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_BROADCAST_CLIENT_RECORD Lib "QCAP.DLL" (ByVal pClient As Long) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY Lib "QCAP.DLL" (ByVal pClient As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight As Long) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BROADCAST_CLIENT_TEXT Lib "QCAP.DLL" (ByVal pClient As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, Optional ByVal nTextStartPosX As Long = 0, Optional ByVal nTextStartPosY As Long = 0, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE Lib "QCAP.DLL" (ByVal pClient As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER Lib "QCAP.DLL" (ByVal pClient As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, Optional ByVal dwKeyColor As Long = &H0, Optional ByVal nKeyColorThreshold As Long = 25, Optional ByVal pMaskBuffer As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszProperty As String, ByRef pszValue As String) As ResultOfFunction

Public Declare Function QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY Lib "QCAP.DLL" (ByVal pClient As Long, ByVal pszProperty As String, ByVal pszValue As String) As ResultOfFunction

' 3D BROADCASTING CLIENT FUNCTIONS (3D 1SHARE STREAMING RX FUNCTIONS)
'
Public Declare Function QCAP_CREATE_3D_BROADCAST_CLIENT Lib "QCAP.DLL" (ByVal iCliNum As Long, ByVal pszURL As String, ByRef ppClient As Long, ByVal nDecoderType As Long, Optional ByVal hAttachedWindowL As Long = 0, Optional ByVal bThumbDrawL As Boolean = 0, Optional ByVal bMaintainAspectRatioL As Boolean = 0, Optional ByVal hAttachedWindowR As Long = 0, Optional ByVal bThumbDrawR As Boolean = 0, Optional ByVal bMaintainAspectRatioR As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE Lib "QCAP.DLL" (ByVal pClient As Long, ByRef pStereoDisplayMode As Long, ByRef pLeftRightSwap As Boolean) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE Lib "QCAP.DLL" (ByVal pClient As Long, Optional ByVal nStereoDisplayMode As Long = StereoDisplayModeEnum.QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE, Optional ByVal bLeftRightSwap As Boolean = 0) As ResultOfFunction

' COMMUNICATION SERVER FUNCTIONS
'
Public Declare Function QCAP_CREATE_COMMUNICATION_ONVIF_SERVER Lib "QCAP.DLL" (ByVal nTotalVideoSources As Long, ByVal nTotalAudioSources As Long, ByVal nTotalVideoEncoders As Long, ByVal nTotalAudioEncoders As Long, ByVal nTotalProfiles As Long, ByRef ppServer As Long, Optional ByVal pszManufacturer As String = "", Optional ByVal pszModel As String = "", Optional ByVal pszFirmwareVersion As String = "", Optional ByVal pszSerialNumber As String = "", Optional ByVal pszHardwareID As String = "") As ResultOfFunction

Public Declare Function QCAP_DESTROY_COMMUNICATION_SERVER Lib "QCAP.DLL" (ByVal pServer As Long) As ResultOfFunction

Public Declare Function QCAP_START_COMMUNICATION_SERVER Lib "QCAP.DLL" (ByVal pServer As Long, Optional ByVal nNetworkPort_ONVIF As Long = 8001) As ResultOfFunction

Public Declare Function QCAP_STOP_COMMUNICATION_SERVER Lib "QCAP.DLL" (ByVal pServer As Long) As ResultOfFunction

Public Declare Function QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iVidSrcNum As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Long) As ResultOfFunction

Public Declare Function QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iVidSrcNum As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal nFrameRate As Long) As ResultOfFunction

Public Declare Function QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iAudSrcNum As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iAudSrcNum As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iVidEncNum As Long, ByRef pVidSrcNum As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pEncoderFormat As Long, ByRef pFrameRate_Min As Long, ByRef pFrameRate_Max As Long, ByRef pFrameRate_Default As Long, ByRef pRecordMode_Min As Long, ByRef pRecordMode_Max As Long, ByRef pRecordMode_Default As Long, ByRef pQuality_Min As Long, ByRef pQuality_Max As Long, ByRef pQuality_Default As Long, ByRef pBitRate_Min As Long, ByRef pBitRate_Max As Long, ByRef pBitRate_Default As Long, ByRef pGOP_Min As Long, ByRef pGOP_Max As Long, ByRef pGOP_Default As Long) As ResultOfFunction

Public Declare Function QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iVidEncNum As Long, ByVal iVidSrcNum As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal nEncoderFormat As Long, ByVal nFrameRate_Min As Long, ByVal nFrameRate_Max As Long, ByVal nFrameRate_Default As Long, ByVal nRecordMode_Min As Long, ByVal nRecordMode_Max As Long, ByVal nRecordMode_Default As Long, ByVal nQuality_Min As Long, ByVal nQuality_Max As Long, ByVal nQuality_Default As Long, ByVal nBitRate_Min As Long, ByVal nBitRate_Max As Long, ByVal nBitRate_Default As Long, ByVal nGOP_Min As Long, ByVal nGOP_Max As Long, ByVal nGOP_Default As Long) As ResultOfFunction

Public Declare Function QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iAudEncNum As Long, ByRef pAudSrcNum As Long, ByRef pEncoderFormat As Long, ByRef pBitRate_Min As Long, ByRef pBitRate_Max As Long, ByRef pBitRate_Default As Long) As ResultOfFunction

Public Declare Function QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iAudEncNum As Long, ByVal iAudSrcNum As Long, ByVal nEncoderFormat As Long, ByVal nBitRate_Min As Long, ByVal nBitRate_Max As Long, ByVal nBitRate_Default As Long) As ResultOfFunction

Public Declare Function QCAP_GET_COMMUNICATION_SERVER_PROFILE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iProNum As Long, ByRef pAudSrcNum As Long, ByRef ppszURL As String, ByRef pVidEncNum As Long, ByRef pAudEncNum As Long) As ResultOfFunction

Public Declare Function QCAP_SET_COMMUNICATION_SERVER_PROFILE Lib "QCAP.DLL" (ByVal pServer As Long, ByVal iProNum As Long, ByVal iAudSrcNum As Long, ByVal pszURL As String, ByVal iVidEncNum As Long, ByVal iAudEncNum As Long) As ResultOfFunction

' ANIMATION FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_CREATE_ANIMATION_CLIP Lib "QCAP.DLL" (ByVal pszAniFileName As String, ByRef ppClip As Long, ByRef pTotalFrames As Long, ByRef pTotalSprites As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long) As ResultOfFunction

Public Declare Function QCAP_DESTROY_ANIMATION_CLIP Lib "QCAP.DLL" (ByVal pClip As Long) As ResultOfFunction

Public Declare Function QCAP_START_ANIMATION_CLIP Lib "QCAP.DLL" (ByVal pClip As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_ANIMATION_CLIP Lib "QCAP.DLL" (ByVal pClip As Long) As ResultOfFunction

Public Declare Function QCAP_STEP_ANIMATION_CLIP Lib "QCAP.DLL" (ByVal pClip As Long, ByRef pFrameNum As Long, ByRef ppFrameBuffer As Long, ByRef pFrameBufferLen As Long, Optional ByVal bClearBackground As Boolean = 1) As ResultOfFunction

Public Declare Function QCAP_SEEK_ANIMATION_CLIP Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iFrameNum As Long, ByRef ppFrameBuffer As Long, ByRef pFrameBufferLen As Long, Optional ByVal bClearBackground As Boolean = 1) As ResultOfFunction

Public Declare Function QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByRef pPositionX As Long, ByRef pPositionY As Long, ByRef pScaleW As Long, ByRef pScaleH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByVal nPositionX As Long, ByVal nPositionY As Long, ByVal nScaleW As Long, ByVal nScaleH As Long) As ResultOfFunction

Public Declare Function QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByRef pAlpha As Double) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal iFrameNum As Long, ByVal nAlpha As Double) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal pszFilePathName As String) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal bCloneCopy As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal bCloneCopy As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal pDevice As Long, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST, Optional ByVal bCloneCopy As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX Lib "QCAP.DLL" (ByVal pClip As Long, ByVal iSpriteNum As Long, ByVal pDevice As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST, Optional ByVal bCloneCopy As Boolean = 0) As ResultOfFunction

' VIRTUAL CAMERA FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_CREATE_VIRTUAL_CAMERA Lib "QCAP.DLL" (ByVal iCamNum As Long, ByRef ppCamera As Long) As ResultOfFunction

Public Declare Function QCAP_DESTROY_VIRTUAL_CAMERA Lib "QCAP.DLL" (ByVal pCamera As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.DLL" (ByVal pCamera As Long, ByRef pColorSpaceType As Long, ByRef pWidth As Long, ByRef pHeight As Long, ByRef pFrameRate As Double) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal dFrameRate As Double) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.DLL" (ByVal pCamera As Long, ByRef pChannels As Long, ByRef pBitsPerSample As Long, ByRef pSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal nColorSpaceType As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_START_VIRTUAL_CAMERA Lib "QCAP.DLL" (ByVal pCamera As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_VIRTUAL_CAMERA Lib "QCAP.DLL" (ByVal pCamera As Long) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight As Long) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, Optional ByVal nTextStartPosX As Long = 0, Optional ByVal nTextStartPosY As Long = 0, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, Optional ByVal dwKeyColor As Long = &H0, Optional ByVal nKeyColorThreshold As Long = 25, Optional ByVal pMaskBuffer As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

' AUDIO MIXING VIRTUAL CAMERA FUNCTIONS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pCamera As Long, ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER Lib "QCAP.DLL" (ByVal pCamera As Long, Optional ByVal dSampleTime As Double = 0.0#) As ResultOfFunction

' FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_OPEN_FILE Lib "QCAP.DLL" (ByVal pszFileName As String, ByRef ppFile As Long, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByVal hAttachedWindow As Long, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_DESTROY_FILE Lib "QCAP.DLL" (ByVal pFile As Long) As ResultOfFunction

Public Declare Function QCAP_PLAY_FILE Lib "QCAP.DLL" (ByVal pFile As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_FILE Lib "QCAP.DLL" (ByVal pFile As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_FILE Lib "QCAP.DLL" (ByVal pFile As Long) As ResultOfFunction

Public Declare Function QCAP_GET_FILE_POSITION Lib "QCAP.DLL" (ByVal pFile As Long, ByRef pSampleTime As Double) As ResultOfFunction

Public Declare Function QCAP_SET_FILE_POSITION Lib "QCAP.DLL" (ByVal pFile As Long, ByVal dSampleTime As Double) As ResultOfFunction

Public Declare Function QCAP_GET_FILE_PLAYBACK_SPEED Lib "QCAP.DLL" (ByVal pFile As Long, ByRef pSpeed As Double) As ResultOfFunction

Public Declare Function QCAP_SET_FILE_PLAYBACK_SPEED Lib "QCAP.DLL" (ByVal pFile As Long, ByVal dSpeed As Double) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_FILE_REGION_DISPLAY Lib "QCAP.DLL" (ByVal pFile As Long, ByRef pCropX As Long, ByRef pCropY As Long, ByRef pCropW As Long, ByRef pCropH As Long) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_FILE_REGION_DISPLAY Lib "QCAP.DLL" (ByVal pFile As Long, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_FILE_MIRROR Lib "QCAP.DLL" (ByVal pFile As Long, ByRef pHorizontalMirror As Boolean, ByRef pVerticalMirror As Boolean) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_FILE_MIRROR Lib "QCAP.DLL" (ByVal pFile As Long, ByVal bHorizontalMirror As Boolean, ByVal bVerticalMirror As Boolean) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_FILE_VOLUME Lib "QCAP.DLL" (ByVal pFile As Long, ByRef pVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SET_AUDIO_FILE_VOLUME Lib "QCAP.DLL" (ByVal pFile As Long, ByVal nVolume As Long) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_FILE_BMP Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_FILE_JPG Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_FILE_BMP_EX Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_SNAPSHOT_FILE_JPG_EX Lib "QCAP.DLL" (ByVal pFile As Long, ByVal pszFilePathName As String, ByVal nCropX As Long, ByVal nCropY As Long, ByVal nCropW As Long, ByVal nCropH As Long, ByVal nDstW As Long, ByVal nDstH As Long, ByVal nQuality As Long, Optional ByVal bIsAsync As Boolean = 1, Optional ByVal nMilliseconds As Long = 0) As ResultOfFunction

Public Declare Function QCAP_GET_OSD_FILE_TEXT_BOUNDARY Lib "QCAP.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByRef pBoundaryWidth As Long, ByRef pBoundaryHeight As Long) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_FILE_TEXT Lib "QCAP.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszString As String, ByVal pszFontFamilyName As String, ByVal nFontStyle As Long, ByVal nFontSize As Long, ByVal dwFontColor As Long, ByVal dwBackgroundColor As Long, ByVal nTransparent As Long, Optional ByVal nTextStartPosX As Long = 0, Optional ByVal nTextStartPosY As Long = 0, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_FILE_PICTURE Lib "QCAP.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal pszFilePathName As String, ByVal nTransparent As Long, Optional ByVal nSequenceStyle As Long = SequenceStyleEnum.QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

Public Declare Function QCAP_SET_OSD_FILE_BUFFER Lib "QCAP.DLL" (ByVal pFile As Long, ByVal iOsdNum As Long, ByVal x As Long, ByVal y As Long, ByVal w As Long, ByVal h As Long, ByVal nColorSpaceType As Long, ByVal pFrameBuffer As Long, ByVal nFrameWidth As Long, ByVal nFrameHeight As Long, ByVal nFramePitch As Long, ByVal nTransparent As Long, Optional ByVal dwKeyColor As Long = &H0, Optional ByVal nKeyColorThreshold As Long = 25, Optional ByVal pMaskBuffer As Long = 0, Optional ByVal nSequenceStyle As Long = QCAP_SEQUENCE_STYLE_FOREMOST) As ResultOfFunction

' SCF FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_SCF_FILE_ENUMERATION Lib "QCAP.DLL" (ByVal pszFileName As String, ByVal dStartSearchTime As Double, ByVal dStopSearchTime As Double, ByRef pFileSizeHigh As Long, ByRef pFileSizeLow As Long, ByRef pFileStartTime As Double, ByRef pFileStopTime As Double, ByRef pVideoStartTime As Double, ByRef pVideoStopTime As Double, ByRef pAudioStartTime As Double, ByRef pAudioStopTime As Double, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, Optional ByVal bNext As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_OPEN_SCF_FILE Lib "QCAP.DLL" (ByVal iChNum As Long, ByRef ppFile As Long, ByVal nDecoderType As Long, ByVal hAttachedWindow As Long, Optional ByVal bThumbDraw As Boolean = 0, Optional ByVal bMaintainAspectRatio As Boolean = 0, Optional ByVal dStartSampleTime As Double = 0.0#, Optional ByVal dStopSampleTime As Double = 0.0#) As ResultOfFunction

Public Declare Function QCAP_SET_SCF_FILE_TIMER Lib "QCAP.DLL" (ByVal iChNum As Long, ByVal bEnableGlobalTimer As Boolean) As ResultOfFunction

Public Declare Function QCAP_PLAY_GLOBAL_SCF_FILE Lib "QCAP.DLL" () As ResultOfFunction

Public Declare Function QCAP_PAUSE_GLOBAL_SCF_FILE Lib "QCAP.DLL" () As ResultOfFunction

Public Declare Function QCAP_STOP_GLOBAL_SCF_FILE Lib "QCAP.DLL" () As ResultOfFunction

Public Declare Function QCAP_GET_GLOBAL_SCF_FILE_POSITION Lib "QCAP.DLL" (ByRef pSampleTime As Double) As ResultOfFunction

Public Declare Function QCAP_SET_GLOBAL_SCF_FILE_POSITION Lib "QCAP.DLL" (ByVal dSampleTime As Double) As ResultOfFunction

' 3D FILE PLAYBACK FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_OPEN_3D_FILE Lib "QCAP.DLL" (ByVal pszFileName As String, ByRef ppFile As Long, ByRef pIs3D As Boolean, ByVal nDecoderType As Long, ByRef pVideoEncoderFormat As Long, ByRef pVideoWidth As Long, ByRef pVideoHeight As Long, ByRef pVideoFrameRate As Double, ByRef pAudioEncoderFormat As Long, ByRef pAudioChannels As Long, ByRef pAudioBitsPerSample As Long, ByRef pAudioSampleFrequency As Long, ByRef pTotalDurationTimes As Double, ByRef pTotalVideoFrames As Long, ByRef pTotalAudioFrames As Long, ByVal hAttachedWindowL As Long, Optional ByVal bThumbDrawL As Boolean = 0, Optional ByVal bMaintainAspectRatioL As Boolean = 0, Optional ByVal hAttachedWindowR As Long = 0, Optional ByVal bThumbDrawR As Boolean = 0, Optional ByVal bMaintainAspectRatioR As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE Lib "QCAP.DLL" (ByVal pFile As Long, ByRef pStereoDisplayMode As Long, ByRef pLeftRightSwap As Boolean) As ResultOfFunction

Public Declare Function QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE Lib "QCAP.DLL" (ByVal pFile As Long, Optional ByVal nStereoDisplayMode As Long = StereoDisplayModeEnum.QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE, Optional ByVal bLeftRightSwap As Boolean = 0) As ResultOfFunction

' FILE EDITING FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_GET_FILE_VIDEO_STREAM_BUFFER Lib "QCAP.DLL" (ByVal pFile As Long, ByVal iFrameNum As Long, ByVal pStreamBuffer As Long, ByRef pStreamBufferLen As Long, ByRef pIsKeyFrame As Boolean, ByRef pSampleTime As Double) As ResultOfFunction

Public Declare Function QCAP_GET_FILE_AUDIO_STREAM_BUFFER Lib "QCAP.DLL" (ByVal pFile As Long, ByVal iFrameNum As Long, ByVal pStreamBuffer As Long, ByRef pStreamBufferLen As Long, ByRef pSampleTime As Double) As ResultOfFunction

Public Declare Function QCAP_EXPORT_FILE Lib "QCAP.DLL" (ByVal pFile As Long, ByVal dStartSampleTime As Double, ByVal dStopSampleTime As Double, ByVal pszExportedFileName As String) As ResultOfFunction

Public Declare Function QCAP_MERGE_FILES Lib "QCAP.DLL" (ByVal pszFrontEndFileName As String, ByVal pszBackEndFileName As String, ByVal pszMergedFileName As String) As ResultOfFunction

Public Declare Function QCAP_MERGE_FILES_EX_02 Lib "QCAP.DLL" (ByVal pszMergedFileName As String, ByVal nFileArgs As Long, ByVal pszSourceFileName1 As String, ByVal pszSourceFileName2 As String) As ResultOfFunction

Public Declare Function QCAP_MERGE_FILES_EX_03 Lib "QCAP.DLL" (ByVal pszMergedFileName As String, ByVal nFileArgs As Long, ByVal pszSourceFileName1 As String, ByVal pszSourceFileName2 As String, ByVal pszSourceFileName3 As String) As ResultOfFunction

Public Declare Function QCAP_MERGE_FILES_EX_04 Lib "QCAP.DLL" (ByVal pszMergedFileName As String, ByVal nFileArgs As Long, ByVal pszSourceFileName1 As String, ByVal pszSourceFileName2 As String, ByVal pszSourceFileName3 As String, ByVal pszSourceFileName4 As String) As ResultOfFunction

Public Declare Function QCAP_BUILD_VIDEO_ON_DEMAND_FILE Lib "QCAP.DLL" (ByVal pszOriginalFileName As String, ByVal pszVideoOnDemandFileName As String) As ResultOfFunction

' FILE REPAIR FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_DIAGNOSE_FILE Lib "QCAP.DLL" (ByVal pszFileName As String, ByRef pIsHealthy As Boolean) As ResultOfFunction

Public Declare Function QCAP_REPAIR_FILE Lib "QCAP.DLL" (ByVal pszBadFileName As String, ByVal pszRepairedFileName As String) As ResultOfFunction

' CD&DVD BURNING FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_CREATE_BURNING_DRIVE Lib "QCAP.DLL" (ByVal cDriveName As String, ByVal pVolumeName As String, ByRef ppDrive As Long) As ResultOfFunction

Public Declare Function QCAP_DESTROY_BURNING_DRIVE Lib "QCAP.DLL" (ByVal pDrive As Long) As ResultOfFunction

Public Declare Function QCAP_START_BURNING_DRIVE Lib "QCAP.DLL" (ByVal pDrive As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_BURNING_DRIVE Lib "QCAP.DLL" (ByVal pDrive As Long) As ResultOfFunction

Public Declare Function QCAP_UNLOAD_DISC Lib "QCAP.DLL" (ByVal pDrive As Long) As ResultOfFunction

Public Declare Function QCAP_LOAD_DISC Lib "QCAP.DLL" (ByVal pDrive As Long) As ResultOfFunction

Public Declare Function QCAP_GET_DISC_INFO Lib "QCAP.DLL" (ByVal pDrive As Long, ByRef pIsDiscBlank As Boolean, ByRef pIsDiscWriteable As Boolean, ByRef pDiscType As Long, ByRef pDiscRemainCapability As Long) As ResultOfFunction

Public Declare Function QCAP_ERASE_DISC Lib "QCAP.DLL" (ByVal pDrive As Long) As ResultOfFunction

' CAMERA FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_CAMERA_ENUMERATION Lib "QCAP.DLL" (ByRef ppszCameraDevName As String, Optional ByVal bNext As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_DEFAULT_CAMERA Lib "QCAP.DLL" (ByVal pszCameraDevName As String) As ResultOfFunction

' SOUNCARD FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////y////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_SOUNDCARD_ENUMERATION Lib "QCAP.DLL" (ByRef ppszSoundCardDevName As String, Optional ByVal bNext As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_SET_DEFAULT_SOUNDCARD Lib "QCAP.DLL" (ByVal pszMicrophoneDevName As String, ByVal pszLineInDevName As String) As ResultOfFunction

' HELPER FUNCTIONS (FOR .NET DEVELOPER)
'
Public Declare Function QCAP_GET_H264_BUFFER_LAYER_ID Lib "QCAP.DLL" (ByVal pStreamBuffer As Long, ByVal nStreamBufferLen As Long, ByRef pLayerID As Long) As ResultOfFunction

Public Declare Function QCAP_COLORSPACE_YUY2_TO_ABGR32 Lib "QCAP.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, Optional ByVal bHorizontalMirror As Boolean = 0, Optional ByVal bVerticalMirror As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_COLORSPACE_YV12_TO_ABGR32 Lib "QCAP.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, Optional ByVal bHorizontalMirror As Boolean = 0, Optional ByVal bVerticalMirror As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_COLORSPACE_YUY2_TO_BGR24 Lib "QCAP.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, Optional ByVal bHorizontalMirror As Boolean = 0, Optional ByVal bVerticalMirror As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_COLORSPACE_YV12_TO_BGR24 Lib "QCAP.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, Optional ByVal bHorizontalMirror As Boolean = 0, Optional ByVal bVerticalMirror As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_COLORSPACE_YUY2_TO_YV12 Lib "QCAP.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, Optional ByVal bHorizontalMirror As Boolean = 0, Optional ByVal bVerticalMirror As Boolean = 0) As ResultOfFunction

Public Declare Function QCAP_RESIZE_VIDEO_BUFFER Lib "QCAP.DLL" (ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long) As ResultOfFunction

Public Declare Function QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY Lib "QCAP.DLL" (ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByRef nDstWidth As Long, ByRef nDstHeight As Long, ByVal dAngle As Double) As ResultOfFunction

Public Declare Function QCAP_ROTATE_VIDEO_BUFFER Lib "QCAP.DLL" (ByVal nColorSpaceType As Long, ByVal pSrcFrameBuffer As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal nSrcPitch As Long, ByVal pDstFrameBuffer As Long, ByVal nDstWidth As Long, ByVal nDstHeight As Long, ByVal nDstPitch As Long, ByVal dAngle As Double, Optional ByVal pSrcTempFrameBuffer As Long = 0, Optional ByVal pDstTempFrameBuffer As Long = 0, Optional ByVal bClearBackground As Boolean = 1) As ResultOfFunction

Public Declare Function QCAP_LOAD_PICTURE_BUFFER Lib "QCAP.DLL" (ByVal pszFilePathName As String, ByRef pColorSpaceType As Long, ByVal pFrameBuffer As Long, ByRef pFrameBufferSize As Long, ByRef pFrameWidth As Long, ByRef pFrameHeight As Long, ByRef pFramePitch As Long) As ResultOfFunction

Public Declare Function QCAP_GET_AUDIO_BUFFER_VOLUME_DB Lib "QCAP.DLL" (ByVal pFrameBuffer As Long, ByVal nFrameBufferLen As Long, ByVal nChannels As Long, ByVal nBitsPerSample As Long, ByVal nSampleFrequency As Long, ByVal iChNum As Long, ByRef pVolumeDB As Double) As ResultOfFunction

Public Declare Function QCAP_RESAMPLE_AUDIO_BUFFER Lib "QCAP.DLL" (ByVal pSrcFrameBuffer As Long, ByVal nSrcFrameBufferLen As Long, ByVal nSrcChannels As Long, ByVal nSrcBitsPerSample As Long, ByVal nSrcSampleFrequency As Long, ByVal pDstFrameBuffer As Long, ByRef pDstFrameBufferLen As Long, ByVal nDstChannels As Long, ByVal nDstBitsPerSample As Long, ByVal nDstSampleFrequency As Long) As ResultOfFunction

Public Declare Function QCAP_HELPER_OBJPTR_CHAR Lib "QCAP.DLL" Alias "QCAP_HELPER_OBJPTR" (ByRef pObj As Byte) As Long

Public Declare Function QCAP_HELPER_OBJPTR_BYTE Lib "QCAP.DLL" Alias "QCAP_HELPER_OBJPTR" (ByRef pObj As Byte) As Long

Public Declare Function QCAP_HELPER_OBJPTR_SHORT16 Lib "QCAP.DLL" Alias "QCAP_HELPER_OBJPTR" (ByRef pObj As Integer) As Long

Public Declare Function QCAP_HELPER_OBJPTR_USHORT16 Lib "QCAP.DLL" Alias "QCAP_HELPER_OBJPTR" (ByRef pObj As Integer) As Long

Public Declare Function QCAP_HELPER_OBJPTR_LONG32 Lib "QCAP.DLL" Alias "QCAP_HELPER_OBJPTR" (ByRef pObj As Long) As Long

Public Declare Function QCAP_HELPER_OBJPTR_Long Lib "QCAP.DLL" Alias "QCAP_HELPER_OBJPTR" (ByRef pObj As Long) As Long

' MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) (ONLY FOR MP4/FLV) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
' MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) (ONLY FOR MP4/FLV) /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'
Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_02 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_02 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_02 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_02 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long) As ResultOfFunction

Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_03 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pszFilePathName3 As String, ByVal pDevice3 As Long, ByVal iRecNum3 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_03 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_03 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_03 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long) As ResultOfFunction

Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_04 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pszFilePathName3 As String, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pszFilePathName4 As String, ByVal pDevice4 As Long, ByVal iRecNum4 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_04 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_04 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_04 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long) As ResultOfFunction

Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_05 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pszFilePathName3 As String, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pszFilePathName4 As String, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pszFilePathName5 As String, ByVal pDevice5 As Long, ByVal iRecNum5 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_05 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_05 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_05 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long) As ResultOfFunction

Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_06 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pszFilePathName3 As String, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pszFilePathName4 As String, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pszFilePathName5 As String, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pszFilePathName6 As String, ByVal pDevice6 As Long, ByVal iRecNum6 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_06 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_06 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_06 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long) As ResultOfFunction

Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_07 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pszFilePathName3 As String, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pszFilePathName4 As String, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pszFilePathName5 As String, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pszFilePathName6 As String, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pszFilePathName7 As String, ByVal pDevice7 As Long, ByVal iRecNum7 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_07 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pDevice7 As Long, ByVal iRecNum7 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_07 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pDevice7 As Long, ByVal iRecNum7 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_07 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pDevice7 As Long, ByVal iRecNum7 As Long) As ResultOfFunction

Public Declare Function QCAP_START_SYNCHRONIZED_RECORD_08 Lib "QCAP.DLL" Alias "QCAP_START_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pszFilePathName1 As String, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pszFilePathName2 As String, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pszFilePathName3 As String, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pszFilePathName4 As String, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pszFilePathName5 As String, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pszFilePathName6 As String, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pszFilePathName7 As String, ByVal pDevice7 As Long, ByVal iRecNum7 As Long, ByVal pszFilePathName8 As String, ByVal pDevice8 As Long, ByVal iRecNum8 As Long) As ResultOfFunction

Public Declare Function QCAP_STOP_SYNCHRONIZED_RECORD_08 Lib "QCAP.DLL" Alias "QCAP_STOP_SYNCHRONIZED_RECORD" (ByVal bIsAsync As Boolean, ByVal nMilliseconds As Long, ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pDevice7 As Long, ByVal iRecNum7 As Long, ByVal pDevice8 As Long, ByVal iRecNum8 As Long) As ResultOfFunction

Public Declare Function QCAP_RESUME_SYNCHRONIZED_RECORD_08 Lib "QCAP.DLL" Alias "QCAP_RESUME_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pDevice7 As Long, ByVal iRecNum7 As Long, ByVal pDevice8 As Long, ByVal iRecNum8 As Long) As ResultOfFunction

Public Declare Function QCAP_PAUSE_SYNCHRONIZED_RECORD_08 Lib "QCAP.DLL" Alias "QCAP_PAUSE_SYNCHRONIZED_RECORD" (ByVal nFileArgs As Long, ByVal pDevice1 As Long, ByVal iRecNum1 As Long, ByVal pDevice2 As Long, ByVal iRecNum2 As Long, ByVal pDevice3 As Long, ByVal iRecNum3 As Long, ByVal pDevice4 As Long, ByVal iRecNum4 As Long, ByVal pDevice5 As Long, ByVal iRecNum5 As Long, ByVal pDevice6 As Long, ByVal iRecNum6 As Long, ByVal pDevice7 As Long, ByVal iRecNum7 As Long, ByVal pDevice8 As Long, ByVal iRecNum8 As Long) As ResultOfFunction



