#include "setupdlg.h"
#include "ui_setupdlg.h"
#include "channelwindow.h"

SetUpDlg::SetUpDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SetUpDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("SET UP DIALOG");

    this->setMinimumSize(745,300);

    this->setMaximumSize(745,300);

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    ui->BmpPath->setText( SC510dlg->path + QString("/Snapshot_BMP.bmp"));

    ui->JpgPath->setText( SC510dlg->path + QString("/Snapshot_JPG.jpg"));

    ui->RecordPath11->setText( SC510dlg->path + QString("/record_1.mp4"));

    ui->RecordPath12->setText( SC510dlg->path + QString("/record_2.mp4"));

    ui->RecordPath13->setText( SC510dlg->path + QString("/record_3.mp4"));

    ui->checkBox_AVI_11->setChecked(false);

    ui->checkBox_AVI_12->setChecked(false);

    ui->checkBox_AVI_13->setChecked(false);

    ui->checkBox_MP4_11->setChecked(true);

    ui->checkBox_MP4_12->setChecked(true);

    ui->checkBox_MP4_13->setChecked(true);

    ui->GPUSupport11->setChecked(true);

    ui->GPUSupport12->setChecked(true);

    ui->GPUSupport13->setChecked(true);

    ui->pushBTN_StopRecord11->setEnabled(false);

    ui->pushBTN_StopRecord12->setEnabled(false);

    ui->pushBTN_StopRecord13->setEnabled(false);

    ui->checkBox_DEINTERLACE->setChecked(true);

    if( SC510dlg->m_hVideoDevice == 0 )
    {
        ui->pushBTN_AudioInput->setEnabled(false);

        ui->pushBTN_SnapshotBMP->setEnabled(false);

        ui->pushBTN_SnapshotJPG->setEnabled(false);

        ui->pushBTN_StartRecord11->setEnabled(false);

        ui->pushBTN_StartRecord12->setEnabled(false);

        ui->pushBTN_StartRecord13->setEnabled(false);

        ui->pushBTN_VideoInpur->setEnabled(false);

        ui->pushBTN_VideoQuality->setEnabled(false);
    }

    m_nTimerId = startTimer(1000);
}

SetUpDlg::~SetUpDlg()
{
    delete ui;
}

void SetUpDlg::timerEvent( QTimerEvent *event )
{
    //qDebug("event->timerId() = %d",event->timerId());

    if( event->timerId() == m_nTimerId )
    {
        ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

        ui->m_info->setText(SC510dlg->str_info);
    }
}

void SetUpDlg::on_pushBTN_VideoInpur_clicked()
{
    emit SetUpDialogSignal_VideoInput();
}

void SetUpDlg::on_pushBTN_AudioInput_clicked()
{
    emit SetUpDialogSignal_AudioInput();
}

void SetUpDlg::on_pushBTN_SnapshotBMP_clicked()
{
    emit SetUpDialogSignal_Snapshot_BMP();
}

void SetUpDlg::on_pushBTN_SnapshotJPG_clicked()
{
    emit SetUpDialogSignal_Snapshot_JPG();
}

void SetUpDlg::on_pushBTN_StartRecord11_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->GPUSupport11->isChecked())
    {
        SC510dlg->m_bSupportGPU1 = TRUE;
    }

    emit SetUpDialogSignal_StartRecord11();

    ui->pushBTN_StartRecord11->setEnabled(false);

    ui->pushBTN_StopRecord11->setEnabled(true);
}

void SetUpDlg::on_pushBTN_StopRecord11_clicked()
{
    emit SetUpDialogSignal_StopRecord11();

    ui->pushBTN_StartRecord11->setEnabled(true);

    ui->pushBTN_StopRecord11->setEnabled(false);
}

void SetUpDlg::on_pushBTN_StartRecord12_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->GPUSupport12->isChecked())
    {
        SC510dlg->m_bSupportGPU1 = TRUE;
    }

    emit SetUpDialogSignal_StartRecord12();

    ui->pushBTN_StartRecord12->setEnabled(false);

    ui->pushBTN_StopRecord12->setEnabled(true);
}

void SetUpDlg::on_pushBTN_StopRecord12_clicked()
{
    emit SetUpDialogSignal_StopRecord12();

    ui->pushBTN_StartRecord12->setEnabled(true);

    ui->pushBTN_StopRecord12->setEnabled(false);
}

void SetUpDlg::on_pushBTN_StartRecord13_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( ui->GPUSupport13->isChecked())
    {
        SC510dlg->m_bSupportGPU1 = TRUE;
    }

    emit SetUpDialogSignal_StartRecord13();

    ui->pushBTN_StartRecord13->setEnabled(false);

    ui->pushBTN_StopRecord13->setEnabled(true);
}

void SetUpDlg::on_pushBTN_StopRecord13_clicked()
{
    emit SetUpDialogSignal_StopRecord13();

    ui->pushBTN_StartRecord13->setEnabled(true);

    ui->pushBTN_StopRecord13->setEnabled(false);
}

void SetUpDlg::on_pushBTN_VideoQuality_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( SC510dlg->m_hVideoDevice )
    {
        emit SetUpDialogSignal_VideoQuality();
    }
}

void SetUpDlg::on_checkBox_DEINTERLACE_stateChanged(int arg1)
{
    emit SetUpDialogSignal_DEINTERLACE( arg1 );
}

void SetUpDlg::on_checkBox_Clone_stateChanged(int arg1)
{
    emit SetUpDialogSignal_CLONE( arg1 );
}

void SetUpDlg::on_checkBox_AVI_11_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_MP4_11->setChecked(true);

        SC510dlg->m_bMP4_11 = TRUE;

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1.mp4"));
    }
    else
    {
        ui->checkBox_MP4_11->setChecked(false);

        SC510dlg->m_bMP4_11 = FALSE;

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1.avi"));
    }
}

void SetUpDlg::on_checkBox_MP4_11_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI_11->setChecked(true);

        SC510dlg->m_bMP4_11 = FALSE;

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1.avi"));
    }
    else
    {
        ui->checkBox_AVI_11->setChecked(false);

        SC510dlg->m_bMP4_11 = TRUE;

        ui->RecordPath11->setText( SC510dlg->path + QString("/record_1.mp4"));
    }
}

void SetUpDlg::on_checkBox_AVI_12_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_MP4_12->setChecked(true);

        SC510dlg->m_bMP4_12 = TRUE;

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_2.mp4"));
    }
    else
    {
        ui->checkBox_MP4_12->setChecked(false);

        SC510dlg->m_bMP4_12 = FALSE;

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_2.avi"));
    }
}

void SetUpDlg::on_checkBox_MP4_12_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI_12->setChecked(true);

        SC510dlg->m_bMP4_12 = FALSE;

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_2.avi"));
    }
    else
    {
        ui->checkBox_AVI_12->setChecked(false);

        SC510dlg->m_bMP4_12 = TRUE;

        ui->RecordPath12->setText( SC510dlg->path + QString("/record_2.mp4"));
    }
}

void SetUpDlg::on_checkBox_AVI_13_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_MP4_13->setChecked(true);

        SC510dlg->m_bMP4_13 = TRUE;

        ui->RecordPath13->setText( SC510dlg->path + QString("/record_3.mp4"));
    }
    else
    {
        ui->checkBox_MP4_13->setChecked(false);

        SC510dlg->m_bMP4_13 = FALSE;

        ui->RecordPath13->setText( SC510dlg->path + QString("/record_3.avi"));
    }
}

void SetUpDlg::on_checkBox_MP4_13_stateChanged(int arg1)
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( arg1 == 0 )
    {
        ui->checkBox_AVI_13->setChecked(true);

        SC510dlg->m_bMP4_13 = FALSE;

        ui->RecordPath13->setText( SC510dlg->path + QString("/record_3.avi"));
    }
    else
    {
        ui->checkBox_AVI_13->setChecked(false);

        SC510dlg->m_bMP4_13 = TRUE;

        ui->RecordPath13->setText( SC510dlg->path + QString("/record_3.mp4"));
    }
}

void SetUpDlg::closeEvent ( QCloseEvent * e )
{
    emit SetUpDialogSignal_DestroyAP();
}
