unit QCAP.DELPHI;

interface

uses

	Windows, SysUtils, Classes;

type

  PVOID           = Pointer;

  INT             = Integer;

  ULONG           = LongInt;

  DWORD           = LongInt;

  ULONGLONG       = UInt64;

  ASTRING         = AnsiString;

  ACHAR           = AnsiChar;

  PCHAR           = PAnsiChar;

  BOOL            = Boolean;

  PULONG          = ^ULONG;

  PULONGLONG      = ^ULONGLONG;

  PPULONGLONG     = ^PULONGLONG;



// RESULT OF FUNCTION
//
QRESULT = (

	QCAP_RS_SUCCESSFUL						= $00000000,

	QCAP_RS_ERROR_GENERAL					= $00000001,

	QCAP_RS_ERROR_OUT_OF_MEMORY				= $00000002,

	QCAP_RS_ERROR_OUT_OF_RESOURCE			= $00000003,

	QCAP_RS_ERROR_INVALID_DEVICE			= $00000004,

	QCAP_RS_ERROR_INVALID_PARAMETER			= $00000005,

	QCAP_RS_ERROR_NON_SUPPORT				= $00000006,

	QCAP_RS_ERROR_TIMEOUT					= $00000007,

	QCAP_RS_ERROR_INVALID_ANIMATION_SCRIPT	= $00000008,

	QCAP_RS_ERROR_NO_SIGNAL_DETECTED		= $00000009,

	QCAP_RS_ERROR_NEED_MORE_DATA			= $0000000A,

	QCAP_RS_ERROR_CONNECT_FAIL				= $0000000B

);

// RETURN OF CALLBACK
//
QRETURN = (

	QCAP_RT_OK					= $00000000,
	
	QCAP_RT_FAIL				= $00000001,

	QCAP_RT_SKIP_RECORD_NUM_00	= $00010002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_01	= $00020002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_02	= $00040002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_03	= $00080002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_DISPLAY		= $00000004, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK / 
											  //
											  //		  PF_VIDEO_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_BROADCAST_CLIENT_CALLBACK / 
											  //
											  //		  PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK /
											  //
											  //		  PF_VIDEO_DECODER_FILE_CALLBACK / PF_AUDIO_DECODER_FILE_CALLBACK
											  
	QCAP_RT_SKIP_CLONE_DISPLAY	= $00000008, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_00	= $01000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_01	= $02000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_02	= $04000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_03	= $08000010 // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

);


// DEVICE ENUMERATION TYPE
//
const 


	QCAP_ENUM_TYPE_DEVICE_NAME		= 0;

	QCAP_ENUM_TYPE_SERIAL_NUMBER	= 1;



// INPUT VIDEO SOURCE
//
const 


	QCAP_INPUT_TYPE_COMPOSITE	 = 0;

	QCAP_INPUT_TYPE_SVIDEO		 = 1;

	QCAP_INPUT_TYPE_HDMI		 = 2;

	QCAP_INPUT_TYPE_DVI_D		 = 3;

	QCAP_INPUT_TYPE_COMPONENTS	 = 4;

	QCAP_INPUT_TYPE_YCBCR		 = 4;

	QCAP_INPUT_TYPE_DVI_A		 = 5;

	QCAP_INPUT_TYPE_RGB			 = 5;

	QCAP_INPUT_TYPE_VGA			 = 5;

	QCAP_INPUT_TYPE_SDI			 = 6;

	QCAP_INPUT_TYPE_DISPLAY_PORT = 8;

	QCAP_INPUT_TYPE_AUTO		 = 7;



// INPUT AUDIO SOURCE
//
const 


	QCAP_INPUT_TYPE_EMBEDDED_AUDIO			= 0;

	QCAP_INPUT_TYPE_LINE_IN					= 1;

	QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE	= 2;

	QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN		= 3;



// VIDEO STANDARD TYPE
//
const 


	QCAP_STANDARD_TYPE_NTSC_M		= $00000001;

	QCAP_STANDARD_TYPE_NTSC_M_J		= $00000002;

	QCAP_STANDARD_TYPE_NTSC_433		= $00000004;

	QCAP_STANDARD_TYPE_PAL_M		= $00000200;

	QCAP_STANDARD_TYPE_PAL_60		= $00000800;

	QCAP_STANDARD_TYPE_PAL_B		= $00000010;

	QCAP_STANDARD_TYPE_PAL_D		= $00000020;

	QCAP_STANDARD_TYPE_PAL_G		= $00000040;

	QCAP_STANDARD_TYPE_PAL_H		= $00000080;

	QCAP_STANDARD_TYPE_PAL_I		= $00000100;

	QCAP_STANDARD_TYPE_PAL_N		= $00000400;

	QCAP_STANDARD_TYPE_PAL_N_COMBO	= $00100000;

	QCAP_STANDARD_TYPE_AUTO			= $80000000;// DEFAULT, [P.S. SC310N8/N16            (CX2581 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC290N4/SC390N4/N8/N16 (AH8400 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC2B0N4/SC3B0N4/N8/N16 (TW5864 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3A0N4/N8/N16         (FH8735 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3C0N4/N8/N16         (MZ0380 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]



// VIDEO DEINTERLACE TYPE
//
const 


	QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING			  = $00000000;// DEFAULT

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE	  = $00000001;

	QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE	  = $00000002;

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MEDICAL_RGB_REPACK = $00000003;



// COLORSPACE TYPE
//
const 


	QCAP_COLORSPACE_TYEP_RGB24	= 0;	  //   $BBGGRR -> R0 G0 B0 R1 G1 B1 R2 G2 B2 ... >>

	QCAP_COLORSPACE_TYEP_BGR24	= 1;	  //   $RRGGBB -> B0 G0 R0 B1 G1 R1 B2 G2 R2 ... >>

	QCAP_COLORSPACE_TYEP_ARGB32	= 2;	  // $AABBGGRR -> R0 G0 B0 A0 R1 G1 B1 A1 R2 G2 B2 A2 ... >>

	QCAP_COLORSPACE_TYEP_ABGR32	= 3;	  // $AARRGGBB -> B0 G0 R0 A0 B1 G1 R1 A1 B2 G2 R2 A2 ... >>

	QCAP_COLORSPACE_TYEP_YUY2	= $32595559;// 0x32595559 -> MAKEFOURCC('Y', 'U', 'Y', '2')

	QCAP_COLORSPACE_TYEP_UYVY	= $59565955;// 0x59565955 -> MAKEFOURCC('U', 'Y', 'V', 'Y')

	QCAP_COLORSPACE_TYEP_YV12	= $32315659;// 0x32315659 -> MAKEFOURCC('Y', 'V', '1', '2')

	QCAP_COLORSPACE_TYEP_I420	= $30323449;// 0x30323449 -> MAKEFOURCC('I', '4', '2', '0')

	QCAP_COLORSPACE_TYEP_H264	= $34363248;// 0x34363248 -> MAKEFOURCC('H', '2', '6', '4')



// ENCODER TYPE (RECORD PROPERTY)
//
const 


	QCAP_ENCODER_TYPE_SOFTWARE			= 0;

	QCAP_ENCODER_TYPE_HARDWARE			= 1;// IT IS ONLY USED FOR HARDWARE COMPRESSION CAPTURE CARD, SUCH AS SC580 & SC590 & SC5A0

	QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK	= 2;

	QCAP_ENCODER_TYPE_AMD_STREAM		= 3;// DEVELOPING ...

	QCAP_ENCODER_TYPE_NVIDIA_CUDA		= 4;

	QCAP_ENCODER_TYPE_NVIDIA_NVENC		= 5;// DEVELOPING ...



// ENCODER VIDEO FORMAT (RECORD PROPERTY)
//
const 


	QCAP_ENCODER_FORMAT_MPEG2		=  1;

	QCAP_ENCODER_FORMAT_H264		=  0;

	QCAP_ENCODER_FORMAT_H264_3D		=  2;// H264 MVC (STEREOSCOPIC 3D)

	QCAP_ENCODER_FORMAT_H264_VC		=  3;// H264 SVC (MULTIPLE TEMPORAL SCALABILITY)

	QCAP_ENCODER_FORMAT_RAW			=  4;



// ENCODER AUDIO FORMAT (RECORD PROPERTY)
//
const 


	QCAP_ENCODER_FORMAT_PCM			= 0;

	QCAP_ENCODER_FORMAT_AAC			= 1;

	QCAP_ENCODER_FORMAT_AAC_RAW		= 1;

	QCAP_ENCODER_FORMAT_AAC_ADTS	= 2;



// RECORD PROFILE (RECORD PROPERTY)
//
const 


	QCAP_RECORD_PROFILE_BASELINE	         = 0;// DEFAULT

	QCAP_RECORD_PROFILE_MAIN		         = 1;

	QCAP_RECORD_PROFILE_HIGH		         = 2;

	QCAP_RECORD_PROFILE_CONSTRAINED_BASELINE = 3;

	QCAP_RECORD_PROFILE_CONSTRAINED_HIGH     = 4;



// RECORD LEVEL (RECORD PROPERTY)
//
const 


	QCAP_RECORD_LEVEL_1		= 10;

	QCAP_RECORD_LEVEL_1B	=  9;

	QCAP_RECORD_LEVEL_11	= 11;

	QCAP_RECORD_LEVEL_12	= 12;

	QCAP_RECORD_LEVEL_13	= 13;

	QCAP_RECORD_LEVEL_2		= 20;

	QCAP_RECORD_LEVEL_21	= 21;

	QCAP_RECORD_LEVEL_22	= 22;

	QCAP_RECORD_LEVEL_3		= 30;

	QCAP_RECORD_LEVEL_31	= 31;

	QCAP_RECORD_LEVEL_32	= 32;

	QCAP_RECORD_LEVEL_4		= 40;

	QCAP_RECORD_LEVEL_41	= 41;// DEFAULT

	QCAP_RECORD_LEVEL_42	= 42;

	QCAP_RECORD_LEVEL_50	= 50;

	QCAP_RECORD_LEVEL_51	= 51;

	QCAP_RECORD_LEVEL_52	= 52;



// RECORD ENTROPY (RECORD PROPERTY)
//
const 


	QCAP_RECORD_ENTROPY_CAVLC	= 0;// DEFAULT

	QCAP_RECORD_ENTROPY_CABAC	= 1;



// RECORD COMPLEXITY (RECORD PROPERTY)
//
const 


	QCAP_RECORD_COMPLEXITY_0	= 0;// BEST SPEED, DEFAULT

	QCAP_RECORD_COMPLEXITY_1	= 1;

	QCAP_RECORD_COMPLEXITY_2	= 2;

	QCAP_RECORD_COMPLEXITY_3	= 3;

	QCAP_RECORD_COMPLEXITY_4	= 4;

	QCAP_RECORD_COMPLEXITY_5	= 5;

	QCAP_RECORD_COMPLEXITY_6	= 6;// BEST QUALITY



// RECORD MODE (RECORD PROPERTY)
//
const 


	QCAP_RECORD_MODE_VBR	= 0;

	QCAP_RECORD_MODE_CBR	= 1;

	QCAP_RECORD_MODE_ABR	= 2;

	QCAP_RECORD_MODE_CQP	= 3;// DEVELOPING ...



// DOWNSCALE MODE (RECORD PROPERTY)
// 
const 


	QCAP_DOWNSCALE_MODE_OFF	= 0;// (1920, 1080) * (1 / 1) = (1920, 1080)

	QCAP_DOWNSCALE_MODE_2_3	= 1;// (1920, 1080) * (2 / 3) = (1280,  720)

	QCAP_DOWNSCALE_MODE_1_2	= 2;// (1920, 1080) * (1 / 2) = ( 960,  540)

	QCAP_DOWNSCALE_MODE_1_4	= 3;// (1920, 1080) * (1 / 4) = ( 480,  270)



// RECORD FLAG (RECORD PROPERTY)
//
const 


	QCAP_RECORD_FLAG_FULL						= $00000007;

	QCAP_RECORD_FLAG_FILE						= $00000001;

	QCAP_RECORD_FLAG_ENCODE						= $00000002;

	QCAP_RECORD_FLAG_DISPLAY					= $00000004;

	QCAP_RECORD_FLAG_DECODE						= $00000008;

	QCAP_RECORD_FLAG_VIDEO_ONLY					= $00000010;

	QCAP_RECORD_FLAG_AUDIO_ONLY					= $00000020;

	QCAP_RECORD_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	= $00000040;

	QCAP_RECORD_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	= $00000080;

	QCAP_RECORD_FLAG_INGNORE_FORMAT_CHANGED		= $00000100;



// BROADCAST FLAG (BROADCAST PROPERTY)
//
const 


	QCAP_BROADCAST_FLAG_FULL	            = $00000007;

	QCAP_BROADCAST_FLAG_NETWORK	            = $00000001;

	QCAP_BROADCAST_FLAG_ENCODE	            = $00000002;

	QCAP_BROADCAST_FLAG_DISPLAY	            = $00000004;

	QCAP_BROADCAST_FLAG_DECODE	            = $00000008;

	QCAP_BROADCAST_FLAG_VIDEO_ONLY			= $00000010;

	QCAP_BROADCAST_FLAG_AUDIO_ONLY			= $00000020;



// BROADCAST PROTOCOL (BROADCAST PROPERTY)
//
const 


	QCAP_BROADCAST_PROTOCOL_UDP	 = $00000000;

	QCAP_BROADCAST_PROTOCOL_TCP	 = $00000001;// BPS >= 12MBPS, SUGGEST TO SUE QCAP_BROADCAST_PROTOCOL_TCP

	QCAP_BROADCAST_PROTOCOL_HTTP = $00000002;



// OSD FONT STYLE (OSD PROPERTY)
//
const 


    QCAP_FONT_STYLE_REGULAR     = $00000000;
    
	QCAP_FONT_STYLE_BOLD        = $00000001;
    
	QCAP_FONT_STYLE_ITALIC      = $00000002;
    
	QCAP_FONT_STYLE_BOLDITALIC  = $00000003;
    
	QCAP_FONT_STYLE_UNDERLINE   = $00000004;
    
	QCAP_FONT_STYLE_STRIKEOUT   = $00000008;



// OSD SEQUENCE STYLE (OSD PROPERTY)
//
const 


	//  GENERAL DEVICE: FOREMOST -> PREVIEW CALLBACK -> BEFORE_ENCODE -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE RECORDING: FOREMOST -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE STREAMING: FOREMOST -> STREAMING (ENCODING) -> AFTERMOST
	//
	//  VIRTUAL CAMERA: FOREMOST -> AFTERMOST -> SHARING
	//
	//   FILE PLAYBACK: PLAYBACK (DECODING) -> FOREMOST -> DECODER CALLBACK -> AFTERMOST
	//
	QCAP_SEQUENCE_STYLE_FOREMOST		= $00000000;

    QCAP_SEQUENCE_STYLE_BEFORE_ENCODE	= $00000001;// IT IS ONLY USED FOR GENERAL DEVICE
    
	QCAP_SEQUENCE_STYLE_AFTERMOST		= $00000002;



// DECODER TYPE (PLAYBACK PROPERTY)
//
const 


	QCAP_DECODER_TYPE_SOFTWARE			= 0;

	QCAP_DECODER_TYPE_HARDWARE			= 1;// DEVELOPING ...

	QCAP_DECODER_TYPE_INTEL_MEDIA_SDK	= 2;// DEVELOPING ...

	QCAP_DECODER_TYPE_AMD_STREAM		= 3;// DEVELOPING ...

	QCAP_DECODER_TYPE_NVIDIA_CUDA		= 4;// DEVELOPING ...

	QCAP_DECODER_TYPE_NVIDIA_NVENC		= 5;// DEVELOPING ...



// 3D STEREO BUFFER TYPE
//
const 


	QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE		= 0;

	QCAP_3D_STEREO_BUFFER_TOP_BOTTOM		= 1;

	QCAP_3D_STEREO_BUFFER_LINE_BY_LINE		= 2;



// 3D STEREO DISPLAY MODE
//
const 


	QCAP_3D_STEREO_DISPLAY_MODE_SIDE_BY_SIDE	= 0;

	QCAP_3D_STEREO_DISPLAY_MODE_TOP_BOTTOM		= 1;

	QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE	= 2;

	QCAP_3D_STEREO_DISPLAY_MODE_LEFT_ONLY		= 3;

	QCAP_3D_STEREO_DISPLAY_MODE_RIGHT_ONLY		= 4;



type

// CALLBACK FUNCTION TYPES //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
PF_NO_SIGNAL_DETECTED_CALLBACK = function( pDevice : PVOID ; nVideoInput : ULONG ; nAudioInput : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_SIGNAL_REMOVED_CALLBACK = function( pDevice : PVOID ; nVideoInput : ULONG ; nAudioInput : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_FORMAT_CHANGED_CALLBACK = function( pDevice : PVOID ; nVideoInput : ULONG ; nAudioInput : ULONG ; nVideoWidth : ULONG ; nVideoHeight : ULONG ; bVideoIsInterleaved : BOOL ; dVideoFrameRate : Double ; nAudioChannels : ULONG ; nAudioBitsPerSample : ULONG ; nAudioSampleFrequency : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_SNAPSHOT_DONE_CALLBACK = function( pDevice : PVOID ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_SNAPSHOT_STREAM_CALLBACK = function( pDevice : PVOID ; pszFilePathName : PCHAR ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_RECORD_DONE_CALLBACK = function( pDevice : PVOID ; iRecNum : UINT ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_SHARE_RECORD_DONE_CALLBACK = function( iRecNum : UINT ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK = function( iRecNum : UINT ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK = function( iRecNum : UINT ; pszFilePathName : PCHAR ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; pszProperty : PCHAR ; pszValue : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; pszProperty : PCHAR ; pszValue : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; pszFilePathName : PCHAR ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_CLIENT_CONNECTED_CALLBACK = function( pClient : PVOID ; nVideoWidth : ULONG ; nVideoHeight : ULONG ; bVideoIsInterleaved : BOOL ; dVideoFrameRate : Double ; nAudioChannels : ULONG ; nAudioBitsPerSample : ULONG ; nAudioSampleFrequency : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK = function( pClient : PVOID ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK = function( pClient : PVOID ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK = function( pClient : PVOID ; pszFilePathName : PCHAR ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK = function( pServer : PVOID ; iProNum : UINT ; nEncoderFormat : ULONG ; nWidth : ULONG ; nHeight : ULONG ; nFrameRate : ULONG ; nRecordMode : ULONG ; nQuality : ULONG ; nBitRate : ULONG ; nGOP : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK = function( pServer : PVOID ; iProNum : UINT ; nEncoderFormat : ULONG ; nChannels : ULONG ; nBitsPerSample : ULONG ; nSampleFrequency : ULONG ; nBitRate : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK = function( pCamera : PVOID ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK = function( pCamera : PVOID ; pszFilePathName : PCHAR ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_FILE_SNAPSHOT_DONE_CALLBACK = function( pFile : PVOID ; pszFilePathName : PCHAR ; pUserData : PVOID  ): QRETURN; cdecl;

PF_FILE_SNAPSHOT_STREAM_CALLBACK = function( pFile : PVOID ; pszFilePathName : PCHAR ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_PREVIEW_CALLBACK = function( pDevice : PVOID ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_PREVIEW_CALLBACK = function( pDevice : PVOID ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_HARDWARE_ENCODER_CALLBACK = function( pDevice : PVOID ; iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : BOOL ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_RECORD_CALLBACK = function( pDevice : PVOID ; iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : BOOL ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_RECORD_CALLBACK = function( pDevice : PVOID ; iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_MEDIA_RECORD_CALLBACK = function( pDevice : PVOID ; iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : BOOL ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_MX_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; iTrackNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_MEDIA_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK = function( iRecNum : UINT ; iTrackNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_BROADCAST_SERVER_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : BOOL ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_BROADCAST_SERVER_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK = function( pServer : PVOID ; iSessionNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_BROADCAST_CLIENT_CALLBACK = function( pClient : PVOID ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : BOOL ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_BROADCAST_CLIENT_CALLBACK = function( pClient : PVOID ; dSampleTime : Double ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK = function( pClient : PVOID ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK = function( pClient : PVOID ; iChNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK = function( pClient : PVOID ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_DECODER_FILE_CALLBACK = function( pFile : PVOID ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_VIDEO_DECODER_3D_FILE_CALLBACK = function( pFile : PVOID ; iChNum : UINT ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

PF_AUDIO_DECODER_FILE_CALLBACK = function( pFile : PVOID ; dSampleTime : Double ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; pUserData : PVOID  ): QRETURN; cdecl;

// CALLBACK FUNCTIONS PART.I (EVENT) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
IN*/, PF_NO_SIGNAL_DETECTED_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_SIGNAL_REMOVED_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_FORMAT_CHANGED_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_SNAPSHOT_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iRecNum /*IN*/, PF_RECORD_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_SHARE_RECORD_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_BROADCAST_CLIENT_CONNECTED_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_FILE_SNAPSHOT_DONE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

// CALLBACK FUNCTIONS PART.II (DATA) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
IN*/, PF_VIDEO_PREVIEW_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_PREVIEW_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iRecNum /*IN*/, PF_VIDEO_HARDWARE_ENCODER_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

// CALLBACK FUNCTIONS PART.III (DATA) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
IN*/, PF_SNAPSHOT_STREAM_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_FILE_SNAPSHOT_STREAM_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

// CALLBACK FUNCTIONS PART.IIII (DATA) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
IN*/, UINT iRecNum /*IN*/, PF_VIDEO_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iRecNum /*IN*/, PF_AUDIO_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iRecNum /*IN*/, PF_MEDIA_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ); // ONLY FOR TS & FLV FILE FORMA: QRETURN; cdecl;

IN*/, PF_VIDEO_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_MX_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_MEDIA_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ); // ONLY FOR TS & FLV FILE FORMA: QRETURN; cdecl;

IN*/, PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_BROADCAST_SERVER_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_BROADCAST_SERVER_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIDEO_BROADCAST_CLIENT_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_BROADCAST_CLIENT_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIDEO_DECODER_FILE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_VIDEO_DECODER_3D_FILE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

IN*/, PF_AUDIO_DECODER_FILE_CALLBACK = functionpCB /*IN*/ pUserData : PVOID  ): QRETURN; cdecl;

// SYSTEM FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_VERSION( var pMajorVersion : ULONG ; var pMinorVersion : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_SYSTEM_CONFIGURATION(   bEnableMultipleUsersAccess : BOOL ; // If true qcap will alllow multiple users to access the device.

															      bEnableVideoPreviewDevice : BOOL ; // If true the video capture device will be enabled.

															      bEnableAudioPreviewDevice : BOOL ; // If true the audio capture device will be enabled.

															      bEnableVideoHardwareMainEncoderDevice : BOOL ; // If true the main hardware encoder will be enabled.

															      bEnableVideoHardwareSubEncoderDevice : BOOL ; // If true the sub hardware encoder will be enabled.

															     nAutoInputDetectionTimeout : ULONG ; // The parameter allows you to specify the timeout duration of the auto input detection default is 3sec.

															      bEnableSCF : BOOL ; // If true the SCF file recording function will be turned on.
															   
															    pszDB3 : PCHAR ; // The parameter allows you to specify the file path of SQL database.
															   
															      bEnableAsyncBackgroundSnapshot : BOOL ; // If true snapshot function will be moved into another thread. 
															   
															      bEnableEnhancedVideoRenderer : BOOL ; // If true QCAP will enable the DirectShow's Enhanced Video Renderer Filter.
															   
															      bEnableSystemTimeCallback : BOOL ; // If true the preview's and encoder's callbacks will return one local system time at dSampleTime.
															   
															      bEnableFileRepairFunction : BOOL ; // If true the recording file will own self-repaired ability.
															   
															     bEnableNewRTSPLibrary : ULONG ; // If true we will use new rtsp lib to repalce old one after 1.1.0.130.0
																
																pszWebServerRootFolderPath : PCHAR ; // The parameter allows you to specify the web server's root folder path.

																pszWebServerIP : PCHAR ; // The parameter allows you to specify the web server's ip address.

function QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_QUERY_ENCODER_TYPE_CAP( nEncoderType : ULONG  );

function QCAP_QUERY_DECODER_TYPE_CAP( nDecoderType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_QUERY_ENCODER_STATUS( nEncoderType : ULONG ; var pExistInstances : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

// DEVICE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_DEVICE_ENUMERATION( var ppVideoDeviceList : PULONGLONG ; var pVideoDeviceSize : ULONG ; var ppVideoEncoderDeviceList : PULONGLONG ; var pVideoEncoderDeviceSize : ULONG ; var ppAudioDeviceList : PULONGLONG ; var pAudioDeviceSize : ULONG ; var ppAudioEncoderDeviceList : PULONGLONG ; var pAudioEncoderDeviceSize : ULONG ; nDeviceEnumType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO( iDevNum : UINT ; pDeviceList : PULONGLONG ; var pDeviceInfoH : ULONG ; var pDeviceInfoL : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE( pszDevName : PCHAR ; iDevNum : UINT ; hAttachedWindow : HWND ; var ppDevice : PVOID ; bThumbDraw : BOOL ; bMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

// DEVICE NAME TABLE:
//
// "DC1150 USB" IS FOR PD652, PD652.3D
//
// "QP0204 USB" IS FOR PD5A0
//
// "UB658G USB" IS FOR UB658
//
// "CY3014 USB" IS FOR UB530
//
// "TW6802 PCI" IS FOR SC200, SC300, SC230, SC330
//
// "CX2581 PCI" IS FOR SC310, SC340
//
// "CX2385 PCI" IS FOR SC350
//
// "AH8400 PCI" IS FOR SC290, SC390
//
// "FH8735 PCI" IS FOR SC2A0, SC3A0
//
// "TW5864 PCI" IS FOR SC2B0, SC3B0
//
// "MZ0380 PCI" IS FOR SC3C0
//
// "SA7160 PCI" IS FOR SC500, SC510, TB510
//
// "FH8735 PCI" IS FOR SC580
//
// "TW2809 PCI" IS FOR SC590
//
// "QP0203 PCI" IS FOR SC540, SC5A0
//
// "MZ0380 PCI" IS FOR SC3C0, SC5C0
//
//     "CAMERA" IS FOR GENERAL USB CAMERA
//
//  "SOUNDCARD" IS FOR GENERAL SOUND CARD

function QCAP_DESTROY( pDevice : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_RUN( pDevice : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP( pDevice : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_INPUT( pDevice : PVOID ; var pInput : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_INPUT( pDevice : PVOID ; nInput : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_INPUT( pDevice : PVOID ; var pInput : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_INPUT( pDevice : PVOID ; nInput : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_STANDARD( pDevice : PVOID ; var pStandard : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_STANDARD( pDevice : PVOID ; nStandard : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS( pDevice : PVOID ; var pStatus : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT( pDevice : PVOID ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pIsInterleaved : BOOL ; var pFrameRate : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT( pDevice : PVOID ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT( pDevice : PVOID ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pIsInterleaved : BOOL ; var pFrameRate : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT( pDevice : PVOID ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; bIsInterleaved : BOOL ; dFrameRate : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT( pDevice : PVOID ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT( pDevice : PVOID ; nChannels : ULONG ; nBitsPerSample : ULONG ; nSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_DEINTERLACE_TYPE( pDevice : PVOID ; var pType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_DEINTERLACE_TYPE( pDevice : PVOID ; nType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_DEINTERLACE( pDevice : PVOID ; var pEnable : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_DEINTERLACE( pDevice : PVOID ; bEnable : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_REGION_DISPLAY( pDevice : PVOID ; var pCropX : ULONG ; var pCropY : ULONG ; var pCropW : ULONG ; var pCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_REGION_DISPLAY( pDevice : PVOID ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_MIRROR( pDevice : PVOID ; var pHorizontalMirror : BOOL ; var pVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_MIRROR( pDevice : PVOID ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_BRIGHTNESS( pDevice : PVOID ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BRIGHTNESS( pDevice : PVOID ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_CONTRAST( pDevice : PVOID ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_CONTRAST( pDevice : PVOID ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_HUE( pDevice : PVOID ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_HUE( pDevice : PVOID ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_SATURATION( pDevice : PVOID ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SATURATION( pDevice : PVOID ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_SHARPNESS( pDevice : PVOID ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARPNESS( pDevice : PVOID ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX( pDevice : PVOID ; var pDownscaleMode : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX( pDevice : PVOID ; nDownscaleMode : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY( pDevice : PVOID ; iRecNum : UINT ; var pEncoderFormat : ULONG ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pDownscaleMode : ULONG ; var pPostSkipFrameRate : ULONG ; var pPostAvgFrameRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( pDevice : PVOID ; iRecNum : UINT ;   nEncoderFormat : ULONG ;    nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    nDownscaleMode : ULONG ;    nPostSkipFrameRate : ULONG ;    nPostAvgFrameRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( pDevice : PVOID ; iRecNum : UINT ; var pEncoderFormat : ULONG ; var pRecordProfile : ULONG ; var pRecordLevel : ULONG ; var pRecordEntropy : ULONG ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pBFrames : ULONG ; var pIsInterleaved : BOOL ; var pSlices : ULONG ; var pLayers : ULONG ; var pSceneCut : ULONG ; var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pCropX : ULONG ; var pCropY : ULONG ; var pCropW : ULONG ; var pCropH : ULONG ; var pDownscaleMode : ULONG ; var pPostSkipFrameRate : ULONG ; var pPostAvgFrameRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( pDevice : PVOID ; iRecNum : UINT ;   nEncoderFormat : ULONG ;    nRecordProfile : ULONG ;    nRecordLevel : ULONG ;    nRecordEntropy : ULONG ;    nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nBFrames : ULONG ;    bIsInterleaved : BOOL ;    nSlices : ULONG ;    nLayers : ULONG ;    nSceneCut : ULONG ;    nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    nCropX : ULONG ;    nCropY : ULONG ;    nCropW : ULONG ;    nCropH : ULONG ;    nDownscaleMode : ULONG ;    nPostSkipFrameRate : ULONG ;    nPostAvgFrameRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( pDevice : PVOID ; iRecNum : UINT ; nProperty : ULONG ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY( pDevice : PVOID ; iRecNum : UINT ; nProperty : ULONG ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_VOLUME( pDevice : PVOID ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_VOLUME( pDevice : PVOID ; nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_DEVICE_CUSTOM_PROPERTY( pDevice : PVOID ; nProperty : ULONG ; var pValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_DEVICE_CUSTOM_PROPERTY( pDevice : PVOID ; nProperty : ULONG ; nValue : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX( pDevice : PVOID ; nProperty : ULONG ; pValue : PByte ; nBytes : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( pDevice : PVOID ; nProperty : ULONG ; pValue : PByte ; nBytes : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( pDevice : PVOID ;  pCB : PF_NO_SIGNAL_DETECTED_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( pDevice : PVOID ;  pCB : PF_SIGNAL_REMOVED_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( pDevice : PVOID ;  pCB : PF_FORMAT_CHANGED_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( pDevice : PVOID ;  pCB : PF_VIDEO_PREVIEW_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( pDevice : PVOID ;  pCB : PF_AUDIO_PREVIEW_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( pDevice : PVOID ; iRecNum : UINT ;  pCB : PF_VIDEO_HARDWARE_ENCODER_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// LOCK/UNLOCK FUNCTIONS (SUPPORT LABVIEW 2010/2012 DEVELOPER) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_COPY_VIDEO_PREVIEW_BUFFER( pDevice : PVOID ; var pSampleTime : Double ; pFrameBuffer : PByte ; var pFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_COPY_AUDIO_PREVIEW_BUFFER( pDevice : PVOID ; var pSampleTime : Double ; pFrameBuffer : PByte ; var pFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_LOCK_VIDEO_PREVIEW_BUFFER( pDevice : PVOID ; var pSampleTime : Double ; var ppFrameBuffer : PByte ; var pFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER( pDevice : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_LOCK_AUDIO_PREVIEW_BUFFER( pDevice : PVOID ; var pSampleTime : Double ; var ppFrameBuffer : PByte ; var pFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER( pDevice : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// SNAPSHOT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_SNAPSHOT_BMP( pDevice : PVOID ; pszFilePathName : PCHAR ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_JPG( pDevice : PVOID ; pszFilePathName : PCHAR ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BMP_EX( pDevice : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_JPG_EX( pDevice : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK( pDevice : PVOID ;  pCB : PF_SNAPSHOT_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK( pDevice : PVOID ;  pCB : PF_SNAPSHOT_STREAM_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// CHANNEL RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS CHANNEL RECORDING) (RECNUM: 0 ~ 3) /////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_VIDEO_RECORD_PROPERTY( pDevice : PVOID ; iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pDownscaleMode : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_RECORD_PROPERTY( pDevice : PVOID ; iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    nDownscaleMode : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_RECORD_PROPERTY_EX( pDevice : PVOID ; iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pRecordProfile : ULONG ;  var pRecordLevel : ULONG ;  var pRecordEntropy : ULONG ;  var pRecordComplexity : ULONG ;  var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pBFrames : ULONG ;  var pIsInterleaved : BOOL ;  var pSlices : ULONG ;  var pLayers : ULONG ;  var pSceneCut : ULONG ;  var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pCropX : ULONG ; var pCropY : ULONG ; var pCropW : ULONG ; var pCropH : ULONG ; var pDstW : ULONG ; var pDstH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_RECORD_PROPERTY_EX( pDevice : PVOID ; iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nRecordProfile : ULONG ;     nRecordLevel : ULONG ;     nRecordEntropy : ULONG ;     nRecordComplexity : ULONG ;     nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nBFrames : ULONG ;     bIsInterleaved : BOOL ;     nSlices : ULONG ;     nLayers : ULONG ;     nSceneCut : ULONG ;     nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    nCropX : ULONG ;    nCropY : ULONG ;    nCropW : ULONG ;    nCropH : ULONG ;    nDstW : ULONG ;    nDstH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_RECORD_PROPERTY( pDevice : PVOID ; iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_RECORD_PROPERTY( pDevice : PVOID ; iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_RECORD_PROPERTY_EX( pDevice : PVOID ; iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pBitRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_RECORD_PROPERTY_EX( pDevice : PVOID ; iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nBitRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY( pDevice : PVOID ; iRecNum : UINT ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY( pDevice : PVOID ; iRecNum : UINT ;   nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_CLONE_RECORD( pDevice : PVOID ; iRecNum : UINT ; pszFilePathNameA : PCHAR ; pszFilePathNameB : PCHAR ; dwFlags : DWORD ; dVideoDelayTime : Double ; dAudioDelayTime : Double ; dSegmentDurationTime : Double ; nSegmentDurationSizeKB : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_RECORD( pDevice : PVOID ; iRecNum : UINT ; pszFilePathName : PCHAR ; dwFlags : DWORD ; dVideoDelayTime : Double ; dAudioDelayTime : Double ; dSegmentDurationTime : Double ; nSegmentDurationSizeKB : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_RECORD( pDevice : PVOID ; iRecNum : UINT ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_RESUME_RECORD( pDevice : PVOID ; iRecNum : UINT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PAUSE_RECORD( pDevice : PVOID ; iRecNum : UINT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_RECORD_DONE_CALLBACK( pDevice : PVOID ; iRecNum : UINT ;  pCB : PF_RECORD_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_RECORD_CALLBACK( pDevice : PVOID ; iRecNum : UINT ;  pCB : PF_VIDEO_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_RECORD_CALLBACK( pDevice : PVOID ; iRecNum : UINT ;  pCB : PF_AUDIO_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_MEDIA_RECORD_CALLBACK( pDevice : PVOID ; iRecNum : UINT ;  pCB : PF_MEDIA_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// CLONE FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_CLONE( pDevice : PVOID ; hAttachedWindow : HWND ; var ppCloneDevice : PVOID ; bThumbDraw : BOOL ; bMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

// OSD FUNCTIONS (SUPPORT MULTIPLE-LAYERS OSD OBJECTS) (OSDNUM: 0 ~ 127) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
function QCAP_GET_OSD_TEXT_BOUNDARY( pDevice : PVOID ; iOsdNum : UINT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; var pBoundaryWidth : ULONG ; var pBoundaryHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_TEXT( pDevice : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; dwFontColor : DWORD ; dwBackgroundColor : DWORD ; nTransparent : ULONG ; nTextStartPosX : INT ; nTextStartPosY : INT ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_PICTURE( pDevice : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszFilePathName : PCHAR ; nTransparent : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BUFFER( pDevice : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; nColorSpaceType : ULONG ; pFrameBuffer : PByte ; nFrameWidth : ULONG ; nFrameHeight : ULONG ; nFramePitch : ULONG ; nTransparent : ULONG ; dwKeyColor : DWORD ; nKeyColorThreshold : ULONG ;  pMaskBuffer : PByte ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

// MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) //////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
															   

															  

															   

															   
// SYNCHRONIZED RECORDING EXAMPLE
//
//
//								      "SR_CH02.MP4", pDevices[ 1 ], 0, 
//
//								      "SR_CH03.MP4", pDevices[ 2 ], 0, 
//
//								      "SR_CH04.MP4", pDevices[ 3 ], 0 );
//
//
//										      pDevices[ 1 ], 0, 
//
//										      pDevices[ 2 ], 0, 
//
//										      pDevices[ 3 ], 0 );

// SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 31) ////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY( iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pFrameRate : Double ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pAttachedWindow : HWND ; var pThumbDraw : BOOL ; var pMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nColorSpaceType : ULONG ;    nWidth : ULONG ;    nHeight : ULONG ;    dFrameRate : Double ;    nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    hAttachedWindow : HWND ;    bThumbDraw : BOOL ;   bMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX( iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pFrameRate : Double ; var pRecordProfile : ULONG ;  var pRecordLevel : ULONG ;  var pRecordEntropy : ULONG ;  var pRecordComplexity : ULONG ;  var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pBFrames : ULONG ;  var pIsInterleaved : BOOL ;  var pSlices : ULONG ;  var pLayers : ULONG ;  var pSceneCut : ULONG ;  var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pAttachedWindow : HWND ; var pThumbDraw : BOOL ; var pMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX( iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nColorSpaceType : ULONG ;    nWidth : ULONG ;    nHeight : ULONG ;    dFrameRate : Double ;    nRecordProfile : ULONG ;     nRecordLevel : ULONG ;     nRecordEntropy : ULONG ;     nRecordComplexity : ULONG ;     nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nBFrames : ULONG ;     bIsInterleaved : BOOL ;     nSlices : ULONG ;     nLayers : ULONG ;     nSceneCut : ULONG ;     nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    hAttachedWindow : HWND ;    bThumbDraw : BOOL ;   bMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY( iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG ;    nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX( iRecNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG ; var pBitRate : ULONG ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX( iRecNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG ;    nBitRate : ULONG ;    nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY( iRecNum : UINT ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY( iRecNum : UINT ;   nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; bForceKeyFrame : BOOL ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( iRecNum : UINT ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX( iRecNum : UINT ; nChannels : ULONG ; nBitsPerSample : ULONG ; nSampleFrequency : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( iRecNum : UINT ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER( iRecNum : UINT ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_SHARE_RECORD( iRecNum : UINT ; pszFilePathName : PCHAR ; dwFlags : DWORD ; dVideoDelayTime : Double ; dAudioDelayTime : Double ; dSegmentDurationTime : Double ; nSegmentDurationSizeKB : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_SHARE_RECORD( iRecNum : UINT ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_RESUME_SHARE_RECORD( iRecNum : UINT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PAUSE_SHARE_RECORD( iRecNum : UINT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_SHARE_RECORD_BMP( iRecNum : UINT ; pszFilePathName : PCHAR ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_SHARE_RECORD_JPG( iRecNum : UINT ; pszFilePathName : PCHAR ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX( iRecNum : UINT ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX( iRecNum : UINT ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY( iRecNum : UINT ; iOsdNum : UINT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; var pBoundaryWidth : ULONG ; var pBoundaryHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_SHARE_RECORD_TEXT( iRecNum : UINT ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; dwFontColor : DWORD ; dwBackgroundColor : DWORD ; nTransparent : ULONG ; nTextStartPosX : INT ; nTextStartPosY : INT ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_SHARE_RECORD_PICTURE( iRecNum : UINT ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszFilePathName : PCHAR ; nTransparent : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_SHARE_RECORD_BUFFER( iRecNum : UINT ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; nColorSpaceType : ULONG ; pFrameBuffer : PByte ; nFrameWidth : ULONG ; nFrameHeight : ULONG ; nFramePitch : ULONG ; nTransparent : ULONG ; dwKeyColor : DWORD ; nKeyColorThreshold : ULONG ;  pMaskBuffer : PByte ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK( iRecNum : UINT ;  pCB : PF_SHARE_RECORD_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK( iRecNum : UINT ;  pCB : PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK( iRecNum : UINT ;  pCB : PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_VIDEO_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_AUDIO_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_MEDIA_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// VIDEO 3D SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 31) ///////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nStereoBufferType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nStereoBufferType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX( iRecNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER( iRecNum : UINT ; nStereoDisplayMode : ULONG ; bLeftRightSwap : BOOL ; bForceKeyFrame : BOOL ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

// AUDIO MIXING SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 31) (TRACKNUM: 0 ~ 3) //////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX( iRecNum : UINT ; var pTracks : ULONG ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG ; var pBitRate : ULONG ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX( iRecNum : UINT ;   nTracks : ULONG ;    nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG ;    nBitRate : ULONG ;    nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER( iRecNum : UINT ; iTrackNum : UINT ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER( iRecNum : UINT ; iTrackNum : UINT ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER( iRecNum : UINT ; iTrackNum : UINT ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_AUDIO_MX_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK( iRecNum : UINT ;  pCB : PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS) (SVRNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_BROADCAST_RTSP_SERVER( iSvrNum : UINT ; nTotalSessions : ULONG ; var ppServer : PVOID ; pszAccount : PCHAR ; pszPassword : PCHAR ; nNetworkPort_RTSP : ULONG ; nNetworkPort_RTSPOverHTTP : ULONG ;  bEnableMulticasting : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE_BROADCAST_RTMP_SERVER( iSvrNum : UINT ; nTotalSessions : ULONG ; var ppServer : PVOID ; pszAccount : PCHAR ; pszPassword : PCHAR ; nNetworkPort_RTMP : ULONG ; nNetworkPort_RTMPOverHTTP : ULONG ;  pszServerName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE_BROADCAST_RTMP_SERVER_EX( iSvrNum : UINT ; nTotalSessions : ULONG ; var ppServer : PVOID ; pszAccount : PCHAR ; pszPassword : PCHAR ; nNetworkPort_RTMP : ULONG ; nNetworkPort_RTMPOverHTTP : ULONG ;  pszServerName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER( iSvrNum : UINT ; pszURL : PCHAR ; var ppServer : PVOID ; pszAccount : PCHAR ; pszPassword : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX( iSvrNum : UINT ; pszURL : PCHAR ; var ppServer : PVOID ; pszAccount : PCHAR ; pszPassword : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER( iSvrNum : UINT ; pszURL : PCHAR ; var ppServer : PVOID ; pszAccount : PCHAR ; pszPassword : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CREATE_BROADCAST_HLS_SERVER( iSvrNum : UINT ; nTotalSessions : ULONG ; var ppServer : PVOID ; pszWebServerRootFolderPath : PCHAR ; pszSubFolderPath : PCHAR ; nSegmentDuration : ULONG ; pszWebServerIP : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_BROADCAST_SERVER( pServer : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_BROADCAST_SERVER( pServer : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_BROADCAST_SERVER( pServer : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ; var ppszSessionName : PCHAR ; var pVideoDelayLiveDuration : ULONG ; var pAudioDelayLiveDuration : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ; pszSessionName : PCHAR ;  nVideoDelayLiveDuration : ULONG ; nAudioDelayLiveDuration : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE( pServer : PVOID ; iSessionNum : UINT ; pDevice : PVOID ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX( pServer : PVOID ; iSessionNum : UINT ; pDevice : PVOID ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pFrameRate : Double ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pAttachedWindow : HWND ; var pThumbDraw : BOOL ; var pMaintainAspectRatio : BOOL ; var pFlags : DWORD  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nColorSpaceType : ULONG ;    nWidth : ULONG ;    nHeight : ULONG ;    dFrameRate : Double ;    nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    hAttachedWindow : HWND ;    bThumbDraw : BOOL ;   bMaintainAspectRatio : BOOL ;  dwFlags : DWORD  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX( pServer : PVOID ; iSessionNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pFrameRate : Double ; var pRecordProfile : ULONG ;  var pRecordLevel : ULONG ;  var pRecordEntropy : ULONG ;  var pRecordComplexity : ULONG ;  var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG ; var pBFrames : ULONG ;  var pIsInterleaved : BOOL ;  var pSlices : ULONG ;  var pLayers : ULONG ;  var pSceneCut : ULONG ;  var pAspectRatioX : ULONG ; var pAspectRatioY : ULONG ; var pAttachedWindow : HWND ; var pThumbDraw : BOOL ; var pMaintainAspectRatio : BOOL ; var pFlags : DWORD  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX( pServer : PVOID ; iSessionNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nColorSpaceType : ULONG ;    nWidth : ULONG ;    nHeight : ULONG ;    dFrameRate : Double ;    nRecordProfile : ULONG ;     nRecordLevel : ULONG ;     nRecordEntropy : ULONG ;     nRecordComplexity : ULONG ;     nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG ;    nBFrames : ULONG ;     bIsInterleaved : BOOL ;     nSlices : ULONG ;     nLayers : ULONG ;     nSceneCut : ULONG ;     nAspectRatioX : ULONG ;    nAspectRatioY : ULONG ;    hAttachedWindow : HWND ;    bThumbDraw : BOOL ;   bMaintainAspectRatio : BOOL ;  dwFlags : DWORD  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG ;    nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX( pServer : PVOID ; iSessionNum : UINT ; var pEncoderType : ULONG ; var pEncoderFormat : ULONG ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG ; var pBitRate : ULONG ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX( pServer : PVOID ; iSessionNum : UINT ;   nEncoderType : ULONG ;    nEncoderFormat : ULONG ;    nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG ;    nBitRate : ULONG ;    nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ; var pRecordMode : ULONG ; var pQuality : ULONG ; var pBitRate : ULONG ; var pGOP : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY( pServer : PVOID ; iSessionNum : UINT ;   nRecordMode : ULONG ;    nQuality : ULONG ;    nBitRate : ULONG ;    nGOP : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; bForceKeyFrame : BOOL ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX( pServer : PVOID ; iSessionNum : UINT ; nChannels : ULONG ; nBitsPerSample : ULONG ; nSampleFrequency : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; bIsKeyFrame : ULONG ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_SERVER_BMP( pServer : PVOID ; iSessionNum : UINT ; pszFilePathName : PCHAR ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_SERVER_JPG( pServer : PVOID ; iSessionNum : UINT ; pszFilePathName : PCHAR ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX( pServer : PVOID ; iSessionNum : UINT ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX( pServer : PVOID ; iSessionNum : UINT ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY( pServer : PVOID ; iSessionNum : UINT ; iOsdNum : UINT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; var pBoundaryWidth : ULONG ; var pBoundaryHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BROADCAST_SERVER_TEXT( pServer : PVOID ; iSessionNum : UINT ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; dwFontColor : DWORD ; dwBackgroundColor : DWORD ; nTransparent : ULONG ; nTextStartPosX : INT ; nTextStartPosY : INT ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BROADCAST_SERVER_PICTURE( pServer : PVOID ; iSessionNum : UINT ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszFilePathName : PCHAR ; nTransparent : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BROADCAST_SERVER_BUFFER( pServer : PVOID ; iSessionNum : UINT ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; nColorSpaceType : ULONG ; pFrameBuffer : PByte ; nFrameWidth : ULONG ; nFrameHeight : ULONG ; nFramePitch : ULONG ; nTransparent : ULONG ; dwKeyColor : DWORD ; nKeyColorThreshold : ULONG ;  pMaskBuffer : PByte ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK( pServer : PVOID ;  pCB : PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK( pServer : PVOID ;  pCB : PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK( pServer : PVOID ; iSessionNum : UINT ;  pCB : PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK( pServer : PVOID ; iSessionNum : UINT ;  pCB : PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK( pServer : PVOID ; iSessionNum : UINT ;  pCB : PF_VIDEO_BROADCAST_SERVER_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK( pServer : PVOID ; iSessionNum : UINT ;  pCB : PF_AUDIO_BROADCAST_SERVER_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK( pServer : PVOID ; iSessionNum : UINT ;  pCB : PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK( pServer : PVOID ; iSessionNum : UINT ;  pCB : PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// VIDEO 3D BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS) (SVRNUM: 0 ~ 63) /////////////////////////////////////////////////////////////////////////////////////////////////////////
//
function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nStereoBufferType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nStereoBufferType : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX( pServer : PVOID ; iSessionNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; nStereoDisplayMode : ULONG ; bLeftRightSwap : BOOL ; bForceKeyFrame : BOOL ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

// AUDIO MIXING BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS) (SVRNUM: 0 ~ 63) /////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer : PVOID ; iSessionNum : UINT ; dSampleTime : Double ;  bClearDelayLive : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

// BROADCASTING RTSP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, "root", "root", 554 );
//
//         CH01 URL -> rtsp://root:root@127.0.0.1:554/session0.mpg
//
//         CH02 URL -> rtsp://root:root@127.0.0.1:554/session1.mpg
//
//         CH03 URL -> rtsp://root:root@127.0.0.1:554/session2.mpg
//
//         CH04 URL -> rtsp://root:root@127.0.0.1:554/session3.mpg
// 
// STEP#02 QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 1 /*CH02*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 2 /*CH03*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 3 /*CH04*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 1 /*CH02*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 2 /*CH03*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 3 /*CH04*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
// STEP#03 QCAP_START_BROADCAST_SERVER( pServer );
//
// STEP#04 QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 /*CH01*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 /*CH02*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 /*CH03*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 /*CH04*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferD, nFrameBufferLenD );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 /*CH01*/, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 /*CH02*/, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 /*CH03*/, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 /*CH04*/, pFrameBufferD, nFrameBufferLenD );
//
// STEP#05 QCAP_STOP_BROADCAST_SERVER( pServer );
//
// STEP#06 QCAP_DRSTROY_BROADCAST_SERVER( pServer );

// BROADCASTING RTMP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, NULL, NULL, 1935 );
//
//         CH01 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session0.mpg (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session1.mpg
//
//         CH03 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session2.mpg
//
//         CH04 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session3.mpg

// BROADCASTING HLS SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, "C:\\AppServ\\www\\", "hls\\", 3000 ); // HERE, C:\\AppServ\\www\\ IS YOUR WEB SERVER ROOT FOLDER, hls\\ is SUB FOLDER TO SAVE HLS FILES
//
//         CH01 URL -> http://xxx.xxx.xxx.xxx/hls/session0.m3u8 (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> http://xxx.xxx.xxx.xxx/hls/session1.m3u8
//
//         CH03 URL -> http://xxx.xxx.xxx.xxx/hls/session2.m3u8
//
//         CH04 URL -> http://xxx.xxx.xxx.xxx/hls/session3.m3u8

// BROADCASTING CLIENT FUNCTIONS (SHARE STREAMING RX FUNCTIONS) (CLINUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_BROADCAST_CLIENT( iCliNum : UINT ; pszURL : PCHAR ; var ppClient : PVOID ; nDecoderType : ULONG ; hAttachedWindow : HWND ; bThumbDraw : BOOL ; bMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_BROADCAST_CLIENT( pClient : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_BROADCAST_CLIENT( pClient : PVOID ; nProtocol : ULONG ; nReconnectionTimeout : ULONG ; nDelayQueueDuration : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_BROADCAST_CLIENT( pClient : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY( pClient : PVOID ; var pCropX : ULONG ; var pCropY : ULONG ; var pCropW : ULONG ; var pCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY( pClient : PVOID ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR( pClient : PVOID ; var pHorizontalMirror : BOOL ; var pVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR( pClient : PVOID ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME( pClient : PVOID ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( pClient : PVOID ; nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_BROADCAST_CLIENT_RECORD( pClient : PVOID ; pszFilePathName : PCHAR ; dVideoDelayTime : Double ; dAudioDelayTime : Double ; dSegmentDurationTime : Double ; nSegmentDurationSizeKB : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_BROADCAST_CLIENT_RECORD( pClient : PVOID ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_RESUME_BROADCAST_CLIENT_RECORD( pClient : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PAUSE_BROADCAST_CLIENT_RECORD( pClient : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP( pClient : PVOID ; pszFilePathName : PCHAR ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG( pClient : PVOID ; pszFilePathName : PCHAR ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX( pClient : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX( pClient : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY( pClient : PVOID ; iOsdNum : UINT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; var pBoundaryWidth : ULONG ; var pBoundaryHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BROADCAST_CLIENT_TEXT( pClient : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; dwFontColor : DWORD ; dwBackgroundColor : DWORD ; nTransparent : ULONG ; nTextStartPosX : INT ; nTextStartPosY : INT ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE( pClient : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszFilePathName : PCHAR ; nTransparent : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER( pClient : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; nColorSpaceType : ULONG ; pFrameBuffer : PByte ; nFrameWidth : ULONG ; nFrameHeight : ULONG ; nFramePitch : ULONG ; nTransparent : ULONG ; dwKeyColor : DWORD ; nKeyColorThreshold : ULONG ;  pMaskBuffer : PByte ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY( pClient : PVOID ; pszProperty : PCHAR ; pszValue : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY( pClient : PVOID ; pszProperty : PCHAR ; pszValue : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK( pClient : PVOID ;  pCB : PF_BROADCAST_CLIENT_CONNECTED_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK( pClient : PVOID ;  pCB : PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK( pClient : PVOID ;  pCB : PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK( pClient : PVOID ;  pCB : PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( pClient : PVOID ;  pCB : PF_VIDEO_BROADCAST_CLIENT_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( pClient : PVOID ;  pCB : PF_AUDIO_BROADCAST_CLIENT_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( pClient : PVOID ;  pCB : PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( pClient : PVOID ;  pCB : PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// 3D BROADCASTING CLIENT FUNCTIONS (3D SHARE STREAMING RX FUNCTIONS) (CLINUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_3D_BROADCAST_CLIENT( iCliNum : UINT ; pszURL : PCHAR ; var ppClient : PVOID ; nDecoderType : ULONG ; hAttachedWindowL : HWND ; bThumbDrawL : BOOL ; bMaintainAspectRatioL : BOOL ; hAttachedWindowR : HWND ; bThumbDrawR : BOOL ; bMaintainAspectRatioR : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE( pClient : PVOID ; var pStereoDisplayMode : ULONG ; var pLeftRightSwap : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE( pClient : PVOID ; nStereoDisplayMode : ULONG ; bLeftRightSwap : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK( pClient : PVOID ;  pCB : PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// BROADCASTING CLIENT EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_CLIENT( 0, "rtsp://root:root@127.0.0.1:554/session0.mpg", &pClient, QCAP_DECODER_TYPE_SOFTWARE, hWindow, TRUE );
//
// STEP#02 QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_video_stream, this );
//
//         QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_audio_stream, this );
//
// STEP#03 QCAP_START_BROADCAST_CLIENT( pClient );
//
// STEP#04 QCAP_STOP_BROADCAST_CLIENT( pClient );
//
// STEP#05 QCAP_DESTROY_BROADCAST_CLIENT( pClient );

// COMMUNICATION SERVER FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
function QCAP_CREATE_COMMUNICATION_ONVIF_SERVER( nTotalVideoSources : ULONG ; nTotalAudioSources : ULONG ; nTotalVideoEncoders : ULONG ; nTotalAudioEncoders : ULONG ; nTotalProfiles : ULONG ; var ppServer : PVOID ; pszManufacturer : PCHAR ; pszModel : PCHAR ; pszFirmwareVersion : PCHAR ; pszSerialNumber : PCHAR ; pszHardwareID : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_COMMUNICATION_SERVER( pServer : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_COMMUNICATION_SERVER( pServer : PVOID ; nNetworkPort_ONVIF : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_COMMUNICATION_SERVER( pServer : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE( pServer : PVOID ; iVidSrcNum : UINT ; var pWidth : ULONG ; var pHeight : ULONG ; var pFrameRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE( pServer : PVOID ; iVidSrcNum : UINT ;   nWidth : ULONG ;    nHeight : ULONG ;    nFrameRate : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE( pServer : PVOID ; iAudSrcNum : UINT ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE( pServer : PVOID ; iAudSrcNum : UINT ;   nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER( pServer : PVOID ; iVidEncNum : UINT ; var pVidSrcNum : UINT ; var pWidth : ULONG ; var pHeight : ULONG ; var pEncoderFormat : ULONG ; var pFrameRate_Min : ULONG ; var pFrameRate_Max : ULONG ; var pFrameRate_Default : ULONG ; var pRecordMode_Min : ULONG ; var pRecordMode_Max : ULONG ; var pRecordMode_Default : ULONG ; var pQuality_Min : ULONG ; var pQuality_Max : ULONG ; var pQuality_Default : ULONG ; var pBitRate_Min : ULONG ; var pBitRate_Max : ULONG ; var pBitRate_Default : ULONG ; var pGOP_Min : ULONG ; var pGOP_Max : ULONG ; var pGOP_Default : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER( pServer : PVOID ; iVidEncNum : UINT ;   iVidSrcNum : UINT ;    nWidth : ULONG ;    nHeight : ULONG ;    nEncoderFormat : ULONG ;    nFrameRate_Min : ULONG ;    nFrameRate_Max : ULONG ;    nFrameRate_Default : ULONG ;    nRecordMode_Min : ULONG ;    nRecordMode_Max : ULONG ;    nRecordMode_Default : ULONG ;    nQuality_Min : ULONG ;    nQuality_Max : ULONG ;    nQuality_Default : ULONG ;    nBitRate_Min : ULONG ;    nBitRate_Max : ULONG ;    nBitRate_Default : ULONG ;    nGOP_Min : ULONG ;    nGOP_Max : ULONG ;    nGOP_Default : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER( pServer : PVOID ; iAudEncNum : UINT ; var pAudSrcNum : UINT ; var pEncoderFormat : ULONG ; var pBitRate_Min : ULONG ; var pBitRate_Max : ULONG ; var pBitRate_Default : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER( pServer : PVOID ; iAudEncNum : UINT ;   iAudSrcNum : UINT ;    nEncoderFormat : ULONG ;    nBitRate_Min : ULONG ;    nBitRate_Max : ULONG ;    nBitRate_Default : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_COMMUNICATION_SERVER_PROFILE( pServer : PVOID ; iProNum : UINT ; var ppszURL : PCHAR ; var pVidEncNum : UINT ; var pAudEncNum : UINT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_COMMUNICATION_SERVER_PROFILE( pServer : PVOID ; iProNum : UINT ;   pszURL : PCHAR ;     iVidEncNum : UINT ;    iAudEncNum : UINT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK( pServer : PVOID ;  pCB : PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK( pServer : PVOID ;  pCB : PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// COMMUNICATION CLIENT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

// ANIMATION FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_ANIMATION_CLIP( pszAniFileName : PCHAR ; var ppClip : PVOID ; var pTotalFrames : ULONG ; var pTotalSprites : ULONG ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_ANIMATION_CLIP( pClip : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_ANIMATION_CLIP( pClip : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_ANIMATION_CLIP( pClip : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STEP_ANIMATION_CLIP( pClip : PVOID ; var pFrameNum : UINT ; var ppFrameBuffer : PByte ; var pFrameBufferLen : ULONG ; bClearBackground : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SEEK_ANIMATION_CLIP( pClip : PVOID ; iFrameNum : UINT ; var ppFrameBuffer : PByte ; var pFrameBufferLen : ULONG ; bClearBackground : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( pClip : PVOID ; iSpriteNum : UINT ; iFrameNum : UINT ; var pPositionX : INT ; var pPositionY : INT ; var pScaleW : INT ; var pScaleH : INT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( pClip : PVOID ; iSpriteNum : UINT ; iFrameNum : UINT ; nPositionX : INT ; nPositionY : INT ; nScaleW : INT ; nScaleH : INT  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY( pClip : PVOID ; iSpriteNum : UINT ; iFrameNum : UINT ; var pAlpha : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY( pClip : PVOID ; iSpriteNum : UINT ; iFrameNum : UINT ; nAlpha : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE( pClip : PVOID ; iSpriteNum : UINT ; pszFilePathName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( pClip : PVOID ; iSpriteNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; bCloneCopy : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX( pClip : PVOID ; iSpriteNum : UINT ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; bCloneCopy : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( pClip : PVOID ; iSpriteNum : UINT ; pDevice : PVOID ; nSequenceStyle : ULONG ; bCloneCopy : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX( pClip : PVOID ; iSpriteNum : UINT ; pDevice : PVOID ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nSequenceStyle : ULONG ; bCloneCopy : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

// ANIMATION EXAMPLE:
//
// STEP#01 QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.FADEOUT.XML", &pClip, &nFrames, &nSprites, &nColorSpaceType, &nWidth, &nHeight );
//
// STEP#02 QCAP_START_ANIMATION_CLIP( pClip );
//
// STEP#03 QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( pClip, 0 /*CH01*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
// 
//         QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( pClip, 1 /*CH02*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
// STEP#04 QCAP_STEP_ANIMATION_CLIP( pClip, &iFrameNum, &pFrameBuffer, &nFrameBufferLen, TRUE );
//
// STEP#05 QCAP_STOP_ANIMATION_CLIP( pClip );
//
// STEP#06 QCAP_DESTROY_ANIMATION_CLIP( pClip );

// VIRTUAL CAMERA FUNCTIONS (CAMNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_VIRTUAL_CAMERA( iCamNum : UINT ; var ppCamera : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_VIRTUAL_CAMERA( pCamera : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY( pCamera : PVOID ; var pColorSpaceType : ULONG ; var pWidth : ULONG ; var pHeight : ULONG ; var pFrameRate : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY( pCamera : PVOID ;   nColorSpaceType : ULONG ;    nWidth : ULONG ;    nHeight : ULONG ;    dFrameRate : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY( pCamera : PVOID ; var pChannels : ULONG ; var pBitsPerSample : ULONG ; var pSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY( pCamera : PVOID ;   nChannels : ULONG ;    nBitsPerSample : ULONG ;    nSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( pCamera : PVOID ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX( pCamera : PVOID ; nColorSpaceType : ULONG ; nWidth : ULONG ; nHeight : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( pCamera : PVOID ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX( pCamera : PVOID ; nChannels : ULONG ; nBitsPerSample : ULONG ; nSampleFrequency : ULONG ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_VIRTUAL_CAMERA( pCamera : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_VIRTUAL_CAMERA( pCamera : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP( pCamera : PVOID ; pszFilePathName : PCHAR ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG( pCamera : PVOID ; pszFilePathName : PCHAR ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX( pCamera : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX( pCamera : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY( pCamera : PVOID ; iOsdNum : UINT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; var pBoundaryWidth : ULONG ; var pBoundaryHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT( pCamera : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; dwFontColor : DWORD ; dwBackgroundColor : DWORD ; nTransparent : ULONG ; nTextStartPosX : INT ; nTextStartPosY : INT ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE( pCamera : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszFilePathName : PCHAR ; nTransparent : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER( pCamera : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; nColorSpaceType : ULONG ; pFrameBuffer : PByte ; nFrameWidth : ULONG ; nFrameHeight : ULONG ; nFramePitch : ULONG ; nTransparent : ULONG ; dwKeyColor : DWORD ; nKeyColorThreshold : ULONG ;  pMaskBuffer : PByte ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK( pCamera : PVOID ;  pCB : PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK( pCamera : PVOID ;  pCB : PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// AUDIO MIXING VIRTUAL CAMERA FUNCTIONS (CAMNUM: 0 ~ 63) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER( pCamera : PVOID ; pFrameBuffer : PByte ; nFrameBufferLen : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( pCamera : PVOID ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

// FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_OPEN_FILE( pszFileName : PCHAR ; var ppFile : PVOID ; nDecoderType : ULONG ; var pVideoEncoderFormat : ULONG ; var pVideoWidth : ULONG ; var pVideoHeight : ULONG ; var pVideoFrameRate : Double ; var pAudioEncoderFormat : ULONG ; var pAudioChannels : ULONG ; var pAudioBitsPerSample : ULONG ; var pAudioSampleFrequency : ULONG ; var pTotalDurationTimes : Double ; var pTotalVideoFrames : ULONG ; var pTotalAudioFrames : ULONG ; hAttachedWindow : HWND ; bThumbDraw : BOOL ; bMaintainAspectRatio : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_FILE( pFile : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PLAY_FILE( pFile : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PAUSE_FILE( pFile : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_FILE( pFile : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_FILE_POSITION( pFile : PVOID ; var pSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_FILE_POSITION( pFile : PVOID ; dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_FILE_PLAYBACK_SPEED( pFile : PVOID ; var pSpeed : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_FILE_PLAYBACK_SPEED( pFile : PVOID ; dSpeed : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_FILE_REGION_DISPLAY( pFile : PVOID ; var pCropX : ULONG ; var pCropY : ULONG ; var pCropW : ULONG ; var pCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_FILE_REGION_DISPLAY( pFile : PVOID ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_FILE_MIRROR( pFile : PVOID ; var pHorizontalMirror : BOOL ; var pVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_FILE_MIRROR( pFile : PVOID ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_FILE_VOLUME( pFile : PVOID ; var pVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_AUDIO_FILE_VOLUME( pFile : PVOID ; nVolume : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_FILE_BMP( pFile : PVOID ; pszFilePathName : PCHAR ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_FILE_JPG( pFile : PVOID ; pszFilePathName : PCHAR ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_FILE_BMP_EX( pFile : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SNAPSHOT_FILE_JPG_EX( pFile : PVOID ; pszFilePathName : PCHAR ; nCropX : ULONG ; nCropY : ULONG ; nCropW : ULONG ; nCropH : ULONG ; nDstW : ULONG ; nDstH : ULONG ; nQuality : ULONG ; bIsAsync : BOOL ; nMilliseconds : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_OSD_FILE_TEXT_BOUNDARY( pFile : PVOID ; iOsdNum : UINT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; var pBoundaryWidth : ULONG ; var pBoundaryHeight : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_FILE_TEXT( pFile : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszString : PCHAR ; pszFontFamilyName : PCHAR ; nFontStyle : ULONG ; nFontSize : ULONG ; dwFontColor : DWORD ; dwBackgroundColor : DWORD ; nTransparent : ULONG ; nTextStartPosX : INT ; nTextStartPosY : INT ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_FILE_PICTURE( pFile : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; pszFilePathName : PCHAR ; nTransparent : ULONG ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_OSD_FILE_BUFFER( pFile : PVOID ; iOsdNum : UINT ; x : INT ; y : INT ; w : INT ; h : INT ; nColorSpaceType : ULONG ; pFrameBuffer : PByte ; nFrameWidth : ULONG ; nFrameHeight : ULONG ; nFramePitch : ULONG ; nTransparent : ULONG ; dwKeyColor : DWORD ; nKeyColorThreshold : ULONG ;  pMaskBuffer : PByte ; nSequenceStyle : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( pFile : PVOID ;  pCB : PF_FILE_SNAPSHOT_DONE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK( pFile : PVOID ;  pCB : PF_FILE_SNAPSHOT_STREAM_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( pFile : PVOID ;  pCB : PF_VIDEO_DECODER_FILE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( pFile : PVOID ;  pCB : PF_AUDIO_DECODER_FILE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// SCF FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_SCF_FILE_ENUMERATION( iChNum : UINT ; dStartSearchTime : Double ; dStopSearchTime : Double ; var pFileSizeHigh : ULONG ; var pFileSizeLow : ULONG ; var pFileStartTime : Double ; var pFileStopTime : Double ; var pVideoStartTime : Double ; var pVideoStopTime : Double ; var pAudioStartTime : Double ; var pAudioStopTime : Double ; var pVideoEncoderFormat : ULONG ; var pVideoWidth : ULONG ; var pVideoHeight : ULONG ; var pVideoFrameRate : Double ; var pAudioEncoderFormat : ULONG ; var pAudioChannels : ULONG ; var pAudioBitsPerSample : ULONG ; var pAudioSampleFrequency : ULONG ; var pTotalDurationTimes : Double ; var pTotalVideoFrames : ULONG ; var pTotalAudioFrames : ULONG ; bNext : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_OPEN_SCF_FILE( iChNum : UINT ; var ppFile : PVOID ; nDecoderType : ULONG ; hAttachedWindow : HWND ; bThumbDraw : BOOL ; bMaintainAspectRatio : BOOL ; dStartSampleTime : Double ; dStopSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_SCF_FILE_TIMER( iChNum : UINT ; bEnableGlobalTimer : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PLAY_GLOBAL_SCF_FILE (): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_PAUSE_GLOBAL_SCF_FILE (): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_GLOBAL_SCF_FILE (): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_GLOBAL_SCF_FILE_POSITION( var pSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_GLOBAL_SCF_FILE_POSITION( dSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

// 3D FILE PLAYBACK FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_OPEN_3D_FILE( pszFileName : PCHAR ; var ppFile : PVOID ; var pIs3D : BOOL ; nDecoderType : ULONG ; var pVideoEncoderFormat : ULONG ; var pVideoWidth : ULONG ; var pVideoHeight : ULONG ; var pVideoFrameRate : Double ; var pAudioEncoderFormat : ULONG ; var pAudioChannels : ULONG ; var pAudioBitsPerSample : ULONG ; var pAudioSampleFrequency : ULONG ; var pTotalDurationTimes : Double ; var pTotalVideoFrames : ULONG ; var pTotalAudioFrames : ULONG ; hAttachedWindowL        : HWND ; bThumbDrawL : BOOL ; bMaintainAspectRatioL : BOOL ; hAttachedWindowR : HWND ; bThumbDrawR : BOOL ; bMaintainAspectRatioR : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE( pFile : PVOID ; var pStereoDisplayMode : ULONG ; var pLeftRightSwap : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE( pFile : PVOID ; nStereoDisplayMode : ULONG ; bLeftRightSwap : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK( pFile : PVOID ;  pCB : PF_VIDEO_DECODER_3D_FILE_CALLBACK ; pUserData : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// FILE EDITING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_VIDEO_FILE_STREAM_BUFFER( pFile : PVOID ; iFrameNum : UINT ; pStreamBuffer : PByte ; var pStreamBufferLen : ULONG ; var pIsKeyFrame : BOOL ; var pSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_AUDIO_FILE_STREAM_BUFFER( pFile : PVOID ; iFrameNum : UINT ; pStreamBuffer : PByte ; var pStreamBufferLen : ULONG ; var pSampleTime : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_EXPORT_FILE( pFile : PVOID ; dStartSampleTime : Double ; dStopSampleTime : Double ; pszExportedFileName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_MERGE_FILES( pszFrontEndFileName : PCHAR ; pszBackEndFileName : PCHAR ; pszMergedFileName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';


function QCAP_BUILD_VIDEO_ON_DEMAND_FILE( pszOriginalFileName : PCHAR ; pszVideoOnDemandFileName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

// FILE REPAIR FUNCTIONS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_DIAGNOSE_FILE( pszFileName : PCHAR ; var pIsHealthy : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_REPAIR_FILE( pszBadFileName : PCHAR ; pszRepairedFileName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

// CD&DVD BURNING FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CREATE_BURNING_DRIVE( cDriveName : ACHAR ; pVolumeName : PCHAR ; var ppDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_DESTROY_BURNING_DRIVE( pDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_START_BURNING_DRIVE( pDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_STOP_BURNING_DRIVE( pDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_UNLOAD_DISC( pDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_LOAD_DISC( pDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_DISC_INFO( pDrive : PVOID ; var pIsDiscBlank : BOOL ; var pIsDiscWriteable : BOOL ; var pDiscType : DWORD ; pDiscRemainCapability : PULONGLONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_ERASE_DISC( pDrive : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

// BURNING EXAMPLE (BETA VERSION):
// 
// STEP#01 QCAP_CREATE_BURNING_DRIVE( 'E', "TEST", &pDrive );
//
// STEP#02 QCAP_START_BURNING_DRIVE( pDrive );
// 
// STEP#03 QCAP_START_RECORD( pDevice, 0, "E:\\CH01.TS" );
// 
// STEP#04 QCAP_STOP_RECORD( pDevice, 0, FALSE, INFINE ); // NOTE!! WAITIING FILE CLOSE
// 
// STEP#05 QCAP_STOP_BURNING_DRIVE( pDrive );
// 
// STEP#06 QCAP_UNLOAD_DISC( pDrive );
// 
// STEP#07 QCAP_DESTROY_BURNING_DRIVE( pDrive );

// CAMERA FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_CAMERA_ENUMERATION( var ppszCameraDevName : PCHAR ; bNext : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_DEFAULT_CAMERA( pszCameraDevName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

// SOUNCARD FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_SOUNDCARD_ENUMERATION( var ppszSoundCardDevName : PCHAR ; bNext : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_SET_DEFAULT_SOUNDCARD( pszMicrophoneDevName : PCHAR ; pszLineInDevName : PCHAR  ): QRESULT; cdecl; external 'QCAP.DLL';

// SOUNCARD EXAMPLE:
// 
// STEP#01 QCAP_CREATE( "SOUNDCARD", 0, hWindow, &pDevice, TRUE );
// 
// STEP#02 QCAP_SET_AUDIO_INPUT( pDevice, QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN );
// 
// STEP#03 QCAP_RUN( pDevice );
// 
// STEP#04 QCAP_STOP( pDevice );
// 
// STEP#05 QCAP_DESTROY( pDevice );

// HELPER FUNCTIONS PART.1 (ENCODER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_H264_BUFFER_LAYER_ID( pStreamBuffer : PByte ; nStreamBufferLen : ULONG ; var pLayerID : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

// HELPER FUNCTIONS PART.2 (VIDEO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_COLORSPACE_YUY2_TO_ABGR32( pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; bAlpah : Byte ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_COLORSPACE_YV12_TO_ABGR32( pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; bAlpah : Byte ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_COLORSPACE_YUY2_TO_BGR24(  pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_COLORSPACE_YV12_TO_BGR24(  pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_COLORSPACE_YUY2_TO_YV12(   pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; bHorizontalMirror : BOOL ; bVerticalMirror : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_CONVERT_3D_STEREO_BUFFER( nColorSpaceType : ULONG ; nSrcStereoDisplayMode : ULONG ; pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; nDstStereoDisplayMode : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; bLeftRightSwap : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_RESIZE_VIDEO_BUFFER( nColorSpaceType : ULONG ; pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY( nSrcWidth : ULONG ; nSrcHeight : ULONG ; var pDstWidth : ULONG ; var pDstHeight : ULONG ; dAngle : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_ROTATE_VIDEO_BUFFER( nColorSpaceType : ULONG ; pSrcFrameBuffer : PByte ; nSrcWidth : ULONG ; nSrcHeight : ULONG ; nSrcPitch : ULONG ; pDstFrameBuffer : PByte ; nDstWidth : ULONG ; nDstHeight : ULONG ; nDstPitch : ULONG ; dAngle : Double ; pSrcTempFrameBuffer : PByte ; pDstTempFrameBuffer : PByte ; bClearBackground : BOOL  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_LOAD_PICTURE_BUFFER( pszFilePathName : PCHAR ; var pColorSpaceType : ULONG ; pFrameBuffer : PByte ; var pFrameBufferSize : ULONG ; var pFrameWidth : ULONG ; var pFrameHeight : ULONG ; var pFramePitch : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

// HELPER FUNCTIONS PART.3 (AUDIO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_GET_AUDIO_BUFFER_VOLUME_DB( pFrameBuffer : PByte ; nFrameBufferLen : ULONG ; nChannels : ULONG ; nBitsPerSample : ULONG ; nSampleFrequency : ULONG ; iChNum : UINT ; var pVolumeDB : Double  ): QRESULT; cdecl; external 'QCAP.DLL';

function QCAP_RESAMPLE_AUDIO_BUFFER( pSrcFrameBuffer : PByte ; nSrcFrameBufferLen : ULONG ; nSrcChannels : ULONG ; nSrcBitsPerSample : ULONG ; nSrcSampleFrequency : ULONG ; pDstFrameBuffer : PByte ; var pDstFrameBufferLen : ULONG ; nDstChannels : ULONG ; nDstBitsPerSample : ULONG ; nDstSampleFrequency : ULONG  ): QRESULT; cdecl; external 'QCAP.DLL';

// HELPER FUNCTIONS (FOR .NET DEVELOPER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
function QCAP_HELPER_OBJPTR( pObj : PVOID  ): QRESULT; cdecl; external 'QCAP.DLL';

implementation
end.
