// BaseCapSteupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CBaseCapUI.h"
#include "BaseCapSteupDlg.h"
#include "afxdialogex.h"

extern SETUP_RECORD_PROPERTY_EX *g_ScmRecordProtypeEx;

extern VOID DumpDebugMessage( CHAR * fmt, ... );

extern CBaseCapSteupDlg *pSetupDlg;

// CBaseCapSteupDlg dialog

IMPLEMENT_DYNAMIC(CBaseCapSteupDlg, CDialog)

CBaseCapSteupDlg::CBaseCapSteupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBaseCapSteupDlg::IDD, pParent)
{
	m_editRecordQuality = 0;
	m_editRecordBitrate = 0;
	m_editRecordGop = 0;
	m_editRecordBframe = 0;
	m_editRecordCropx = 0;
	m_editRecordCropy = 0;
	m_editRecordCroph = 0;
	m_editRecordCropw = 0;
	m_editRecordDesh = 0;
	m_editRecordDesw = 0;
	m_editRecordAspectRatioX = 0;
	m_editRecordAspectRatioY = 0;
}

CBaseCapSteupDlg::~CBaseCapSteupDlg()
{
}

void CBaseCapSteupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH, m_editRecordPath);
	DDX_Control(pDX, IDC_COMBO_ENCODE_TYPE, m_comboEncodeType);
	DDX_Control(pDX, IDC_COMBO_ENCODE_FORMAT, m_comboRecorFormat);
	DDX_Control(pDX, IDC_COMBO_RECORD_PROFILE, m_comboRecordProfile);
	DDX_Control(pDX, IDC_COMBO_ENCODE_LEVEL, m_comboEncodeLevel);
	DDX_Control(pDX, IDC_COMBO_RECORD_ENTROPY, m_comboRecordEntropy);
	DDX_Control(pDX, IDC_COMBO_RECORD_COMPLEXITY, m_comboRecordComplexity);
	DDX_Control(pDX, IDC_COMBO_RECORD_MODE, m_comboRecordMode);
	DDX_Text(pDX, IDC_EDIT_RECORD_QUALITY, m_editRecordQuality);
	DDV_MinMaxUInt(pDX, m_editRecordQuality, 0, 10000);
	DDX_Text(pDX, IDC_EDIT_RECORD_BITRATE, m_editRecordBitrate);
	DDV_MinMaxUInt(pDX, m_editRecordBitrate, 0, 64000000);
	DDX_Text(pDX, IDC_EDIT_RECORD_GOP, m_editRecordGop);
	DDV_MinMaxUInt(pDX, m_editRecordGop, 0, 60);
	DDX_Text(pDX, IDC_EDIT_RECORD_BFRAME, m_editRecordBframe);
	DDV_MinMaxUInt(pDX, m_editRecordBframe, 0, 30);
	DDX_Control(pDX, IDC_COMBO_RECORD_DEINTERLACE, m_comboRecordDeinterlace);
	DDX_Text(pDX, IDC_EDIT_RECORD_CROPX, m_editRecordCropx);
	DDV_MinMaxUInt(pDX, m_editRecordCropx, 0, 4096);
	DDX_Text(pDX, IDC_EDIT_RECORD_CROPY, m_editRecordCropy);
	DDV_MinMaxUInt(pDX, m_editRecordCropy, 0, 4096);
	DDX_Text(pDX, IDC_EDIT_RECORD_CROPH, m_editRecordCroph);
	DDV_MinMaxUInt(pDX, m_editRecordCroph, 0, 4096);
	DDX_Text(pDX, IDC_EDIT_RECORD_CROPW, m_editRecordCropw);
	DDV_MinMaxUInt(pDX, m_editRecordCropw, 0, 4096);
	DDX_Text(pDX, IDC_EDIT_RECORD_DESH, m_editRecordDesh);
	DDV_MinMaxUInt(pDX, m_editRecordDesh, 0, 4096);
	DDX_Text(pDX, IDC_EDIT_RECORD_DESW, m_editRecordDesw);
	DDV_MinMaxUInt(pDX, m_editRecordDesw, 0, 4096);
	DDX_Text(pDX, IDC_EDIT_RECORD_ASPECT_RATEX, m_editRecordAspectRatioX);
	DDV_MinMaxUInt(pDX, m_editRecordAspectRatioX, 0, 512);
	DDX_Text(pDX, IDC_EDIT_RECORD_ASPECT_RATEY, m_editRecordAspectRatioY);
	DDV_MinMaxUInt(pDX, m_editRecordAspectRatioY, 0, 512);
}

BEGIN_MESSAGE_MAP(CBaseCapSteupDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CBaseCapSteupDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, &CBaseCapSteupDlg::OnBnClickedCancel)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON1, &CBaseCapSteupDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON_CONFIG, &CBaseCapSteupDlg::OnBnClickedButtonConfig)
	ON_BN_CLICKED(IDC_BUTTON_DEFAULT, &CBaseCapSteupDlg::OnBnClickedButtonDefault)
END_MESSAGE_MAP()


// CBaseCapSteupDlg message handlers


void CBaseCapSteupDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
//	CDialog::OnOK();
}


void CBaseCapSteupDlg::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here
	CDialog::OnCancel();
}


BOOL CBaseCapSteupDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SETUP_RECORD_PROPERTY_EX *pScm = g_ScmRecordProtypeEx;

	//
	//	INITIALIZE SETUP PARAMS
	//

#ifdef SA7160_CAP_UI
	const TCHAR *pszKey = _T("SA7160_CAP_UI"); 
#endif

	::GetProfileString( pszKey, _T("RECORDPATH"), "C:\\DEMO.MP4", pScm->pszRecordFilePathName , 512 );
	m_editRecordPath.SetWindowTextA( pScm->pszRecordFilePathName );

	m_comboEncodeType.AddString( _T("SOFTWARE") );
	m_comboEncodeType.AddString( _T("HARDWARE") );
	m_comboEncodeType.AddString( _T("INTEL MEDIA SDK") );
	m_comboEncodeType.AddString( _T("AMD_STREAM") );
	m_comboEncodeType.AddString( _T("NVIDIA_CUDA") );
	m_comboEncodeType.AddString( _T("NVIDIA_NVENC") );	
	pScm->nEncoderType = ::GetProfileInt( pszKey, _T("ENCODERTYPE"), pScm->nEncoderType );
	m_comboEncodeType.SetCurSel( pScm->nEncoderType );

	m_comboRecorFormat.AddString( _T("H264") );
	m_comboRecorFormat.AddString( _T("MPEG2") );
	m_comboRecorFormat.AddString( _T("H264_3D") );
	pScm->nEncoderFormat = ::GetProfileInt( pszKey, _T("ENCODERFORMAT"), pScm->nEncoderFormat );
	m_comboRecorFormat.SetCurSel( pScm->nEncoderFormat );

	m_comboRecordProfile.AddString(_T("BASELINE"));
	m_comboRecordProfile.AddString(_T("MAIN"));
	m_comboRecordProfile.AddString(_T("HIGH"));
	pScm->nRecordProfile = ::GetProfileInt( pszKey, _T("ENCODERPROFILE"), pScm->nRecordProfile );
	m_comboRecordProfile.SetCurSel( pScm->nRecordProfile );

	//
	// SET THE DATA OF EACH ITEM FOR COMBO CONTROLER
	//
	int pos = 0;
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_1"));
	m_comboEncodeLevel.SetItemData( pos, 10);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_1B"));
	m_comboEncodeLevel.SetItemData( pos, 9);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_11"));
	m_comboEncodeLevel.SetItemData( pos, 11);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_12"));
	m_comboEncodeLevel.SetItemData( pos, 12);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_13"));
	m_comboEncodeLevel.SetItemData( pos, 13);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_2"));
	m_comboEncodeLevel.SetItemData( pos, 20);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_21"));
	m_comboEncodeLevel.SetItemData( pos, 21);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_22"));
	m_comboEncodeLevel.SetItemData( pos, 22);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_3"));
	m_comboEncodeLevel.SetItemData( pos, 30);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_31"));
	m_comboEncodeLevel.SetItemData( pos, 31);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_32"));
	m_comboEncodeLevel.SetItemData( pos, 32);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_4"));
	m_comboEncodeLevel.SetItemData( pos, 40);	
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_41"));
	m_comboEncodeLevel.SetItemData( pos, 41);	
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_42"));
	m_comboEncodeLevel.SetItemData( pos, 42);	
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_50"));
	m_comboEncodeLevel.SetItemData( pos, 50);	
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_51"));
	m_comboEncodeLevel.SetItemData( pos, 51);
	pos = m_comboEncodeLevel.AddString(_T("LEVEL_52"));
	m_comboEncodeLevel.SetItemData( pos, 52);	
	pScm->nRecordLevel = ::GetProfileInt( pszKey, _T("ENCODERLEVEL"), pScm->nRecordLevel );
	for( ULONG i = 0; i < m_comboEncodeLevel.GetCount(); i++ )
	{		
		if( pScm->nRecordLevel == m_comboEncodeLevel.GetItemData( i ) ) { m_comboEncodeLevel.SetCurSel( i ); }
	}

	m_comboRecordComplexity.AddString(_T("COMPLEXITY_0"));
	m_comboRecordComplexity.AddString(_T("COMPLEXITY_1"));
	m_comboRecordComplexity.AddString(_T("COMPLEXITY_2"));
	m_comboRecordComplexity.AddString(_T("COMPLEXITY_3"));
	m_comboRecordComplexity.AddString(_T("COMPLEXITY_4"));
	m_comboRecordComplexity.AddString(_T("COMPLEXITY_5"));
	m_comboRecordComplexity.AddString(_T("COMPLEXITY_6"));
	pScm->nRecordComplexity = ::GetProfileInt( pszKey, _T("ENCODERCOMPLEXITY"), pScm->nRecordComplexity );
	m_comboRecordComplexity.SetCurSel( pScm->nRecordComplexity );

	m_comboRecordEntropy.AddString(_T("CAVLC"));
	m_comboRecordEntropy.AddString(_T("CABAC"));
	pScm->nRecordEntropy = ::GetProfileInt( pszKey, _T("ENCODERENTROPY"), pScm->nRecordEntropy );
	m_comboRecordEntropy.SetCurSel( pScm->nRecordEntropy );

	m_comboRecordMode.AddString(_T("VBR"));
	m_comboRecordMode.AddString(_T("CBR"));
	m_comboRecordMode.AddString(_T("ABR"));
	pScm->nRecordMode = ::GetProfileInt( pszKey, _T("ENCODERMODE"), pScm->nRecordMode );
	m_comboRecordMode.SetCurSel( pScm->nRecordMode );

	pScm->nQuality = ::GetProfileInt( pszKey, _T("ENCODERQUALITY"), pScm->nQuality );
	m_editRecordQuality = pScm->nQuality;

	pScm->nBitRate = ::GetProfileInt( pszKey, _T("ENCODERBITRATE"), pScm->nBitRate );
	m_editRecordBitrate = pScm->nBitRate;

	pScm->nGOP = ::GetProfileInt( pszKey, _T("ENCODERGOP"), pScm->nGOP );
	m_editRecordGop		= pScm->nGOP;

	pScm->nBFrames = ::GetProfileInt( pszKey, _T("ENCODERBFRAME"), pScm->nBFrames );
	m_editRecordBframe	= pScm->nBFrames;

	m_comboRecordDeinterlace.AddString(_T("NO"));
	m_comboRecordDeinterlace.AddString(_T("YES"));
	pScm->bIsInterleaved = ::GetProfileInt( pszKey, _T("ENCODERINTERLACE"), pScm->bIsInterleaved );
	m_comboRecordDeinterlace.SetCurSel( pScm->bIsInterleaved );

	pScm->nCropX = ::GetProfileInt( pszKey, _T("ENCODERCROPX"), pScm->nCropX );
	m_editRecordCropx	= pScm->nCropX;

	pScm->nCropY = ::GetProfileInt( pszKey, _T("ENCODERCROPY"), pScm->nCropY );
	m_editRecordCropy	= pScm->nCropY;

	pScm->nCropW = ::GetProfileInt( pszKey, _T("ENCODERCROPW"), pScm->nCropW );
	m_editRecordCroph	= pScm->nCropW;
	
	pScm->nCropH = ::GetProfileInt( pszKey, _T("ENCODERCROPH"), pScm->nCropH );
	m_editRecordCropw	= pScm->nCropH;	
	
	pScm->nDstH = ::GetProfileInt( pszKey, _T("ENCODERDESH"), pScm->nDstH );
	m_editRecordDesh	= pScm->nDstH;
	
	pScm->nDstW = ::GetProfileInt( pszKey, _T("ENCODERDESW"), pScm->nDstW );
	m_editRecordDesw	= pScm->nDstW;
	
	pScm->nAspectRatioX = ::GetProfileInt( pszKey, _T("ENCODERASPECTX"), pScm->nAspectRatioX );
	m_editRecordAspectRatioX = pScm->nAspectRatioX;

	pScm->nAspectRatioY = ::GetProfileInt( pszKey, _T("ENCODERASPECTY"), pScm->nAspectRatioY );
	m_editRecordAspectRatioY = pScm->nAspectRatioY;

	UpdateData( FALSE );

	// TODO:  Add extra initialization here

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CBaseCapSteupDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here
}


void CBaseCapSteupDlg::OnBnClickedButton1()
{
	SETUP_RECORD_PROPERTY_EX *pScm = g_ScmRecordProtypeEx;
	
    char szPath[ 1024 ];     

    CString str;

    ZeroMemory( szPath, sizeof(szPath) );   

    BROWSEINFO bi;
    bi.hwndOwner		= m_hWnd;
    bi.pidlRoot			= NULL;   
    bi.pszDisplayName	= szPath;   
    bi.lpszTitle		= "Select Record Path:";   
    bi.ulFlags			= 0;   
    bi.lpfn				= NULL;   
    bi.lParam			= 0;   
    bi.iImage			= 0;   
    
    LPITEMIDLIST lp		= SHBrowseForFolder(&bi);   

    if( lp && SHGetPathFromIDList( lp, szPath ) )
	{
		if( strlen(szPath) < 4  ) 
		{
			str.Format( "%sDEMO.MP4",  szPath );
		}
		else
		{
			str.Format( "%s\\DEMO.MP4",  szPath );
		}
		sprintf( pScm->pszRecordFilePathName, "%s", str);
		
		m_editRecordPath.SetWindowTextA( str ); 
	}
    else
	{
		AfxMessageBox("The Direction Not Exist");   	
	}

	// TODO: Add your control notification handler code here
}

void CBaseCapSteupDlg::OnBnClickedButtonConfig()
{
	// TODO: Add your control notification handler code here

	DumpDebugMessage("CBaseCapSteupDlg::Config");

	UpdateData( TRUE );

	SETUP_RECORD_PROPERTY_EX *pScm = g_ScmRecordProtypeEx;

	CHAR sz[512] = {0};

#ifdef SA7160_CAP_UI
	const TCHAR *pszKey = _T("SA7160_CAP_UI"); 
#endif
	//
	//	CONFIG SETUP PARAMS
	//
	m_editRecordPath.GetWindowTextA( pScm->pszRecordFilePathName, 1024 );
	::WriteProfileString( pszKey,  _T("RECORDPATH"), pScm->pszRecordFilePathName );
	
	pScm->nEncoderType = m_comboEncodeType.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nEncoderType);
	::WriteProfileString( pszKey,  _T("ENCODERTYPE"), sz );

	pScm->nEncoderFormat = m_comboRecorFormat.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nEncoderFormat);
	::WriteProfileString( pszKey, _T("ENCODERFORMAT"), sz );

	pScm->nRecordProfile = m_comboRecordProfile.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nRecordProfile);
	::WriteProfileString( pszKey, _T("ENCODERPROFILE"), sz );

	int pos = m_comboEncodeLevel.GetCurSel();
	pScm->nRecordLevel = m_comboEncodeLevel.GetItemData( pos );
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nRecordLevel);
	::WriteProfileString( pszKey, _T("ENCODERLEVEL"), sz );

	pScm->nRecordComplexity = m_comboRecordComplexity.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nRecordComplexity);
	::WriteProfileString( pszKey, _T("ENCODERCOMPLEXITY"), sz );

	pScm->nRecordEntropy = m_comboRecordEntropy.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nRecordEntropy);
	::WriteProfileString( pszKey, _T("ENCODERENTROPY"), sz );
	
	pScm->nRecordMode = m_comboRecordMode.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nRecordMode);
	::WriteProfileString( pszKey, _T("ENCODERMODE"), sz );

	pScm->nQuality = m_editRecordQuality;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nQuality);
	::WriteProfileString( pszKey, _T("ENCODERQUALITY"), sz );

	pScm->nBitRate = m_editRecordBitrate;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nBitRate);
	::WriteProfileString( pszKey, _T("ENCODERBITRATE"), sz );

	pScm->nGOP = m_editRecordGop;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nGOP);
	::WriteProfileString( pszKey, _T("ENCODERGOP"), sz );

	pScm->nBFrames = m_editRecordBframe;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nBFrames);
	::WriteProfileString( pszKey, _T("ENCODERBFRAME"), sz );

	pScm->bIsInterleaved = m_comboRecordDeinterlace.GetCurSel();
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->bIsInterleaved);
	::WriteProfileString( pszKey, _T("ENCODERINTERLACE"), sz );

	pScm->nCropX = m_editRecordCropx;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nCropX);
	::WriteProfileString( pszKey, _T("ENCODERCROPX"), sz );

	pScm->nCropY = m_editRecordCropy;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nCropY);
	::WriteProfileString( pszKey, _T("ENCODERCROPY"), sz );

	pScm->nCropW = m_editRecordCroph;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nCropW);
	::WriteProfileString( pszKey, _T("ENCODERCROPW"), sz );
	
	pScm->nCropH = m_editRecordCropw;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nCropH);
	::WriteProfileString( pszKey, _T("ENCODERCROPH"), sz );
	
	pScm->nDstH = m_editRecordDesh;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nDstH);
	::WriteProfileString( pszKey, _T("ENCODERDESH"), sz );
	
	pScm->nDstW = m_editRecordDesw;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nDstW);
	::WriteProfileString( pszKey, _T("ENCODERDESW"), sz );
	
	pScm->nAspectRatioX = m_editRecordAspectRatioX;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nAspectRatioX);
	::WriteProfileString( pszKey, _T("ENCODERASPECTX"), sz );

	pScm->nAspectRatioY = m_editRecordAspectRatioY;
	memset( sz, 0, strlen(sz) );
	sprintf( sz, "%d", pScm->nAspectRatioY);
	::WriteProfileString( pszKey, _T("ENCODERASPECTY"), sz );

	delete pSetupDlg;

//	CDialog::OnOK();
}

void CBaseCapSteupDlg::OnBnClickedButtonDefault()
{
	DumpDebugMessage("CBaseCapSteupDlg::Default");

	// TODO: Add your control notification handler code here

	SETUP_RECORD_PROPERTY_EX *pScm = g_ScmRecordProtypeEx;

	//
	//	INITIALIZE SETUP PARAMS
	//
	m_editRecordPath.SetWindowTextA( _T("C:\\DEMO.MP4") );
	lstrcpy( pScm->pszRecordFilePathName, "C:\\DEMO.MP4" );

	m_comboEncodeType.SetCurSel( 2 );			pScm->nEncoderType = 2;

	m_comboRecorFormat.SetCurSel( 0 );			pScm->nEncoderFormat = 0;

	m_comboRecordProfile.SetCurSel( 0 );		pScm->nRecordProfile = 0;

	//
	// SET THE DATA OF EACH ITEM FOR COMBO CONTROLER
	//
	for( ULONG i = 0; i < m_comboEncodeLevel.GetCount(); i++ )
	{
		if( 41 == m_comboEncodeLevel.GetItemData( i ) ) { m_comboEncodeLevel.SetCurSel( i ); pScm->nRecordLevel = 41; }
	}

	m_comboRecordComplexity.SetCurSel( 0 );		pScm->nRecordComplexity = 0;

	m_comboRecordEntropy.SetCurSel( 0 );		pScm->nRecordEntropy = 0;

	m_comboRecordMode.SetCurSel( 1 );			pScm->nRecordMode = 1;

	m_editRecordQuality = 8000;					pScm->nQuality = 8000;

	m_editRecordBitrate = 5000000;				pScm->nBitRate = 5000000;

	m_editRecordGop		= 30;					pScm->nGOP = 30;

	m_editRecordBframe	= 0;					pScm->nBFrames = 0;

	m_comboRecordDeinterlace.SetCurSel( 0 );	pScm->bIsInterleaved = 0;

	m_editRecordCropx	= 0;					pScm->nCropX = 0;

	m_editRecordCropy	= 0;					pScm->nCropY = 0;

	m_editRecordCroph	= 0;					pScm->nCropW = 0;
	
	m_editRecordCropw	= 0;					pScm->nCropH = 0;	
	
	m_editRecordDesh	= 0;					pScm->nDstH = 0;
	
	m_editRecordDesw	= 0;					pScm->nDstW = 0;
	
	m_editRecordAspectRatioX = 0;				pScm->nAspectRatioX = 0;

	m_editRecordAspectRatioY = 0;				pScm->nAspectRatioY = 0;

	UpdateData(FALSE);
}
