#ifndef ANIMATIONFACTORYDLG_H
#define ANIMATIONFACTORYDLG_H

#include <QWidget>
#include <QtGui>
#include <QtCore>

namespace Ui {
class AnimationFactoryDlg;
}

class AnimationFactoryDlg : public QWidget
{
    Q_OBJECT

public:
    explicit AnimationFactoryDlg(QWidget *parent = 0);
    ~AnimationFactoryDlg();

    void HwInitialize();

    void HwUninitialize();

private slots:
    void on_pushButton_XML_clicked();

    void on_pushButton_start_clicked();

    void on_pushButton_stop_clicked();

private:
    Ui::AnimationFactoryDlg *ui;

public:
    PVOID           m_hVideoDevice[ 4 ];

    ulong           m_nVideoWidth[ 4 ];

    ulong           m_nVideoHeight[ 4 ];

    bool            m_bVideoIsInterleaved[ 4 ];

    double          m_dVideoFrameRate[ 4 ];

    ulong           m_nAudioChannels[ 4 ];

    ulong           m_nAudioBitsPerSample[ 4 ];

    ulong           m_nAudioSampleFrequency[ 4 ];

    BOOL            m_bIsShareRecord;

    PVOID           m_pClip;

    ULONG           m_nClipFrame;

    ULONG           m_nClipSprite;

    ULONG           m_nClipColorSpaceType;

    ULONG           m_nClipWidth;

    ULONG           m_nClipHeight;

    QString         FilePath;

    QByteArray      FilePath_ByteArray;

    CHAR*           psz;

    volatile ULONG          m_nShareRecordState_audio;

    volatile ULONG          m_nShareRecordState_video;

    CRITICAL_SECTION    	m_hShareRecordAccessCriticalSection_audio;

    CRITICAL_SECTION    	m_hShareRecordAccessCriticalSection_video;
};

#endif // ANIMATIONFACTORYDLG_H
