#ifndef DISPLAYWINDOW_H
#define DISPLAYWINDOW_H

#include <QWidget>
#include <QtGui>
#include <QtCore>

#include "setupdlg.h"

namespace Ui {
class DisplayWindow;
}

class DisplayWindow : public QWidget
{
    Q_OBJECT

public:
    explicit DisplayWindow(QWidget *parent = 0);
    ~DisplayWindow();

    void mousePressEvent(QMouseEvent *event);

    void mouseMoveEvent(QMouseEvent *event);

    void mouseDoubleClickEvent(QMouseEvent *event);

    void HwInitialize();

    void HwUninitialize();

private:
    Ui::DisplayWindow *ui;

    QPoint dragPosition;

public slots:
    void SetUpDialogSlot_DestroyAP();

    void SetUpDialogSlot_Ch1Shift( int value );

    void SetUpDialogSlot_Ch2Shift( int value );

public:
    static DisplayWindow*	s_psc510Dlg;

    SetUpDlg                *m_setupdlg;

    PVOID                   m_hVideoDevice[ 2 ];

    ulong                   m_nVideoWidth[ 2 ];

    ulong                   m_nVideoHeight[ 2 ];

    bool                    m_bVideoIsInterleaved[ 2 ];

    double                  m_dVideoFrameRate[ 2 ];

    ulong                   m_nAudioChannels[ 2 ];

    ulong                   m_nAudioBitsPerSample[ 2 ];

    ulong                   m_nAudioSampleFrequency[ 2 ];

    volatile ULONG          m_nShareRecordState_audio;

    volatile ULONG          m_nShareRecordState_video;

    CRITICAL_SECTION    	m_hShareRecordAccessCriticalSection_audio;

    CRITICAL_SECTION    	m_hShareRecordAccessCriticalSection_video;

    int                     m_nShiftCh1;

    int                     m_nShiftCh2;

    PVOID           		m_pClips[2];

    ULONG           		m_nClipFrames[2];

    ULONG           		m_nClipSprites[2];

    ULONG           		m_nClipColorSpaceTypes[2];

    ULONG           		m_nClipWidths[2];

    ULONG           		m_nClipHeights[2];

    BOOL                    m_bFullScreen;
};

#endif // DISPLAYWINDOW_H
