﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SC2B0
{
    public unsafe partial class MyPeopertyDlg : Form
    {
        public Form1 m_pMainForm;

        public UInt32 m_hDev;

        public MyPeopertyDlg()
        {
            InitializeComponent();
        }

        private void btnDefault_Click(object sender, EventArgs e)
        {
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000000, 128, 0);  // SET BRIGHTNESS VALUE

            m_staticBrightness.Text = "128"; m_sliderBrightness.Value = 128;
            
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000001, 128, 0);  // SET CONTRAST VALUE

            m_staticContrast.Text = "128"; m_sliderContrast.Value = 128;

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000002, 128, 0);  // SET HUE VALUE

            m_staticHue.Text = "128"; m_sliderHue.Value = 128;

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000003, 128, 0);  // SET SATURATION VALUE

            m_staticSaturation.Text = "128"; m_sliderSaturation.Value = 128;

            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000004, 128, 0);  // SET SHARPNESS VALUE            
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Hide();
        }

        private void MyPeopertyDlg_Load(object sender, EventArgs e)
        {
            uint n_property_value = 0;

            AMESDK.NET.EXPORTS.AMESDK_GET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000000, ref n_property_value, 0); // GET BRIGHTNESS VALUE

            m_staticBrightness.Text = n_property_value.ToString();

            m_sliderBrightness.Value = (int)n_property_value;

            AMESDK.NET.EXPORTS.AMESDK_GET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000001, ref n_property_value, 0); // GET CONTRAST VLAUE

            m_staticContrast.Text = n_property_value.ToString();

            m_sliderContrast.Value = (int)n_property_value;

            AMESDK.NET.EXPORTS.AMESDK_GET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000002, ref n_property_value, 0); // GET HUE VALUE

            m_staticHue.Text = n_property_value.ToString();

            m_sliderHue.Value = (int)n_property_value;

            AMESDK.NET.EXPORTS.AMESDK_GET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000003, ref n_property_value, 0); // GET SATURATION VALUE

            m_staticSaturation.Text = n_property_value.ToString();

            m_sliderSaturation.Value = (int)n_property_value;

            AMESDK.NET.EXPORTS.AMESDK_GET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000004, ref n_property_value, 0); // GET SHARPNESS VALUE

            m_staticSharpness.Text = n_property_value.ToString();

            m_sliderSharpness.Value = (int)n_property_value;
        }

        private void MyPeopertyDlg_FormClosed(object sender, FormClosedEventArgs e)
        {

        }

        private void m_sliderBrightness_Scroll(object sender, EventArgs e)
        {
            int n_property_value = m_sliderBrightness.Value;

            m_staticBrightness.Text = n_property_value.ToString();

            // SET BRIGHTNESS VALUE
            //
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000000, (uint)n_property_value, 0);
        }

        private void m_sliderContrast_Scroll(object sender, EventArgs e)
        {
            int n_property_value = m_sliderContrast.Value;

            m_staticContrast.Text = n_property_value.ToString();

            // SET CONTRAST VALUE
            //
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000001, (uint)n_property_value, 0);
        }

        private void m_sliderHue_Scroll(object sender, EventArgs e)
        {
            int n_property_value = m_sliderHue.Value;

            m_staticHue.Text = n_property_value.ToString();

            // SET HUE VALUE
            //
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000002, (uint)n_property_value, 0);
        }

        private void m_sliderSaturation_Scroll(object sender, EventArgs e)
        {
            int n_property_value = m_sliderSaturation.Value;

            m_staticSaturation.Text = n_property_value.ToString();

            // SET SATURATION VALUE
            //
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000003, (uint)n_property_value, 0);
        }

        private void m_sliderSharpness_Scroll(object sender, EventArgs e)
        {
            int n_property_value = m_sliderSharpness.Value;

            m_staticSharpness.Text = n_property_value.ToString();

            // SET SHARPNESS VALUE
            //
            AMESDK.NET.EXPORTS.AMESDK_SET_VIDEOPROCAMP_PROPERTY(m_hDev, 0x00000004, (uint)n_property_value, 0);
        }


    }
}
