﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;

using AMESDK.NET;

[StructLayout(LayoutKind.Sequential)]
public struct SYSTEMTIME
{
    public ushort wYear;
    public ushort wMonth;
    public ushort wDayOfWeek;
    public ushort wDay;
    public ushort wHour;
    public ushort wMinute;
    public ushort wSecond;
    public ushort wMilliseconds;
}

namespace SC2B0
{
    public partial class Form1 : Form
    {
        [DllImport("user32.dll")]
        public static extern uint FindWindow(string classname, string windowname);

        [DllImport("user32.dll")]
        public static extern uint SendMessage(uint hWnd, uint wMsg, uint wParam, uint lParam);

        [DllImport("user32.dll")]
        public static extern uint PostMessage(uint hWnd, uint wMsg, uint wParam, uint lParam);

        [DllImport("Kernel32.dll ")]
        public static extern void GetLocalTime(ref SYSTEMTIME sysTime);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        public static string ByteArrayToString(byte[] array)
        {
            if (array == null)
            {
                throw new ArgumentNullException("array");
            }
            return Encoding.ASCII.GetString(array);
        }

        public uint m_nDisplayTabNumber = 0;  // 0 = LIVE / 1 = RECORD PLAYBACK / 2 = MAIN REALTIME PLAYBACK / 3 = SUB REALTIME PLAYBACK

        public uint m_nDeviceSerialNumber = 0; // DEVICE SERIAL NUMBER

        public uint[] m_hVideoDev = new uint[4]; // VIDEO STREAM CAPTURE DEVICE

        public uint[] m_hVideoMainEncoderDev = new uint[4]; // H.264 MAIN.STREAM CAPTURE DEVICE

        public uint[] m_hVideoSubEncoderDev = new uint[4]; // H.264 SUB.STREAM CAPTURE DEVICE

        uint[] m_hAudioDev = new uint[4]; // AUDIO STREAM CAPTURE DEVICE

        uint[] m_hFileRendererDev = new uint[4]; // FILE RENDERER DEVICE

        uint[] m_nFileRendererRecordState = new uint[4]; // 0 = STOP / 1 = ACQUIRE / 2 = START

        public volatile bool[] m_bFileRendererChangeNotify = new bool[4]; // FILE.CHANGING.EVENT NOTIFY (0 = NONE / 1 = CHANGE)        

        public DateTime[] m_sFileRendererChangeSystemTime = new DateTime[4]; // FILE.CHANGING.EVENT SYSTEM TIME

        public string[] m_pFileRendererChangeDevName = new string[4]; // FILE.CHANGING.EVENT DEVICE NAME

        private Object thisLock = new Object();

        public uint[] m_hFileSourceDev = new uint[4]; // FILE SOURCE DEVICE

        uint m_hNetworkRendererDev; // FNETWORK RENDERER DEVICE

        uint[] m_nNetworkRendererStreamingState = new uint[4]; // 0 = STOP / 1 = ACQUIRE / 2 = START

        // DATA STRUCTURE
        //
        EXPORTS.AMESDK_SECTION_INFO[] m_pSectionData = new EXPORTS.AMESDK_SECTION_INFO[4];

        EXPORTS.AMESDK_MOTION_INFO[] m_pMotionData = new EXPORTS.AMESDK_MOTION_INFO[4];

        EXPORTS.AMESDK_GPS_INFO[] m_pGpsData = new EXPORTS.AMESDK_GPS_INFO[4];

        EXPORTS.AMESDK_POS_INFO[] m_pPosData = new EXPORTS.AMESDK_POS_INFO[4];

        EXPORTS.AMESDK_FILE_INFO[] m_pFileInfo = new EXPORTS.AMESDK_FILE_INFO[4];

        // CALLBACK FUNCTION
        //
        EXPORTS.PF_BUFFER_CALLBACK m_pVideoBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pAudioBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pVideoMainEncoderBufferCB;

        EXPORTS.PF_BUFFER_CALLBACK m_pVideoSubEncoderBufferCB;

        MyChannelControl[] m_cChannelControl_LIVE = new MyChannelControl[4]; // LIVE STREAM DISPLAY WINDOW

        MyChannelControl[] m_cChannelControl_FILE = new MyChannelControl[4]; // FILE STREAM DISPLAY WINDOW (RECORD PLAYBACK)

        MyChannelControl[] m_cChannelControl_H264_MAIN = new MyChannelControl[4]; // H.264 MAIN.STREAM DISPLAY WINDOW (REALTIME PLAYBACK)

        MyChannelControl[] m_cChannelControl_H264_SUB = new MyChannelControl[4]; // H.264 SUB.STREAM DISPLAY WINDOW (REALTIME PLAYBACK) 

        MySetupControl m_cSetupControl = new MySetupControl();

        public MyPeopertyDlg m_cPropertyDlg = new MyPeopertyDlg();

        uint on_process_video_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;

            uint hVideoDev = m_hVideoDev[i];

            uint bIsVisible = 0;

            //uint nLock = 0;

            //uint nFps = 0;

            //EXPORTS.AMESDK_GET_LOCK(hVideoDev, ref nLock);

            //EXPORTS.AMESDK_GET_FPS(hVideoDev, ref nFps);

            //nLock = (nLock / (2 ^ i)) & 0x01;

            if (m_nDisplayTabNumber == 0) { bIsVisible = 1; }

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // MAIN VIDEO ENCODER CALLBACK FUNCTION
        //
        uint on_process_video_main_encoder_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;

            uint hFileRendererDev = m_hFileRendererDev[i];

            bool bKeyFrame = (bIsKeyFrame == 1) ? true : false;

            bool bIsRecord = (m_nFileRendererRecordState[i] == 0x00000002) ? true : false;

            uint bIsVisible = 0;

            if (bKeyFrame)
            {
                if (m_nFileRendererRecordState[i] == 0x00000001)
                {
                    // WAITING KEY FRAME

                    m_nFileRendererRecordState[i] = 0x00000002; // TO GOTO START STATE

                    bIsRecord = true;
                }

                DateTime system_time = DateTime.Now;

                // AUTO FILE SEGMENT (ON.TIMEOUT.EVENT) ( ON 30 MINUTES TIMEOUT EVENT)
                //
                if ((m_sFileRendererChangeSystemTime[i].Minute < 30 && system_time.Minute >= 30) ||
                    (m_sFileRendererChangeSystemTime[i].Minute >= 30 && system_time.Minute < 30) ||
                    (m_sFileRendererChangeSystemTime[i].Hour != system_time.Hour) ||
                    (m_sFileRendererChangeSystemTime[i].Day != system_time.Day) ||
                    (m_sFileRendererChangeSystemTime[i].Month != system_time.Month) ||
                    (m_sFileRendererChangeSystemTime[i].Year != system_time.Year))
                {
                    m_pFileRendererChangeDevName[i] = @"Common Analog File Renderer C:\SC590\CH" + (i + 1).ToString("D2") + "\\" +
                                                                                              system_time.Year.ToString("D4") +
                                                                                              system_time.Month.ToString("D2") +
                                                                                              system_time.Day.ToString("D2") +
                                                                                              system_time.Hour.ToString("D2") +
                                                                                              system_time.Minute.ToString("D2") +
                                                                                              system_time.Second.ToString("D2") + ".AVI";

                    m_sFileRendererChangeSystemTime[i] = system_time;

                    m_bFileRendererChangeNotify[i] = true;
                }

                // CHANGE CURRENT RECORD FILE [FILE.CHANGING.EVENT]
                //
                if (m_bFileRendererChangeNotify[i] == true)
                {
                    uint n_video_color_space_type = 0;

                    uint n_video_frame_width = 0;

                    uint n_video_frame_height = 0;

                    uint n_video_frame_bit_count = 0;

                    double f_video_fps = 0.0;

                    uint dw_video_custom_flags = 0x00000000;

					uint n_audio_steam_type = 0;

                    uint n_audio_channels = 0;

                    uint n_audio_bit_per_sample = 0;

                    uint n_audio_samples_per_sec = 0;

                    // ENTER CRITICAL SECTION
                    //
                    lock (thisLock)
                    {
                        // CLOSE CURRENT RECORD FILE
                        //
                        if (m_hFileRendererDev[i] != 0xFFFFFFFF)
                        {
                            EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[i], ref n_video_color_space_type, ref n_video_frame_width, ref n_video_frame_height, ref n_video_frame_bit_count, ref f_video_fps, ref dw_video_custom_flags);

                            EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[i], ref n_audio_steam_type, ref n_audio_channels, ref n_audio_bit_per_sample, ref n_audio_samples_per_sec);

                            EXPORTS.AMESDK_DESTROY(m_hFileRendererDev[i]);

                            m_hFileRendererDev[i] = 0xFFFFFFFF;
                        }

                        // UPDATE CURRENT FILE INFO LIST
                        //                        
                        uint hWnd = FindWindow("", "Yuan's SC2B0N4 Live + H.264 Dual Stream Demo Software");

                        PostMessage(hWnd, 0x400, i, 0);

                        // CREATE NEW RECORD FILE
                        //
                        m_hFileRendererDev[i] = EXPORTS.AMESDK_CREATE(ref m_pFileRendererChangeDevName[i], i, 3, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

                        EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[i], n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, f_video_fps, dw_video_custom_flags);

                        EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[i], n_audio_steam_type, n_audio_channels, n_audio_bit_per_sample, n_audio_samples_per_sec);
                    }
                    //
                    // LEAVE CRITICAL SECTION

                    m_bFileRendererChangeNotify[i] = false;
                }
            }

            // PUSH ONE VIDEO STREAM BUFFER INTO MEDIA FILE
            //
            if (bIsRecord)
            {
                EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_BUFFER(m_hFileRendererDev[i], pBuffer, nBufferLen, bIsKeyFrame, 0, 0, ref m_pSectionData[i], ref m_pMotionData[i], ref m_pGpsData[i], ref m_pPosData[i]);
            }

            if (m_nDisplayTabNumber == 2) { bIsVisible = 1; }

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // SUB VIDEO ENCODER CALLBACK FUNCTION
        //
        uint on_process_video_sub_encoder_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;

            bool bIsStreaming = (m_nNetworkRendererStreamingState[i] == 0x00000002) ? true : false;

            bool bKeyFrame = (bIsKeyFrame == 1) ? true : false;

            uint bIsVisible = 0;

            if (bKeyFrame)
            {
                if (m_nNetworkRendererStreamingState[i] == 0x00000001)
                {
                    // WAITING KEY FRAME

                    m_nNetworkRendererStreamingState[i] = 0x00000002; // TO GOTO START STATE

                    bIsStreaming = true;
                }
            }

            if (bIsStreaming)
            {
                uint n_buffer_queue_size = 0, n_frame_queue_size = 0, n_clients = 0;

                // CHECK CURRENT STATUS OF NETWORK CONNECTION                
                //
                EXPORTS.AMESDK_NETWORK_GET_VIDEO_STREAM_STATISTICS(m_hNetworkRendererDev, i, ref n_buffer_queue_size, ref n_frame_queue_size, ref n_clients); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

                // PUSH ONE VIDEO STREAM BUFFER INTO NETWORK
                //
                EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER(m_hNetworkRendererDev, i, pBuffer, nBufferLen, bIsKeyFrame, 0, 0); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING                
            }

            if (m_nDisplayTabNumber == 3) { bIsVisible = 1; }

            return bIsVisible; // DISPLAY ON WINDOW
        }

        // AUDIO CALLBACK FUNCTION
        //
        uint on_process_audio_buffer(double dSampleTime, uint pBuffer, uint nBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nChannelNumber = pUserData;

            uint i = nChannelNumber;

            bool bIsStreaming = (m_nNetworkRendererStreamingState[i] == 0x00000002) ? true : false;

            uint bIsMute = 0;
         
            bool bIsRecord = false;

            if (m_nFileRendererRecordState[i] >= 0x00000002) { bIsRecord = true; }

            if (bIsRecord)
            {
                // ENTER CRITICAL SECTION
                //
                lock (thisLock)
                {
                    EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_BUFFER(m_hFileRendererDev[i], pBuffer, nBufferLen, 0, 0, ref m_pSectionData[i]);
                }
                //
                // LEAVE CRITICAL SECTION
            }                       

            if (bIsStreaming)
            {
                uint n_buffer_queue_size = 0, n_frame_queue_size = 0, n_clients = 0;

                // CHECK CURRENT STATUS OF NETWORK CONNECTION                
                // 
                EXPORTS.AMESDK_NETWORK_GET_AUDIO_STREAM_STATISTICS(m_hNetworkRendererDev, i, ref n_buffer_queue_size, ref n_frame_queue_size, ref n_clients); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

                // PUSH ONE AUDIO STREAM BUFFER INTO NETWORK
                //
                EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER(m_hNetworkRendererDev, i, pBuffer, nBufferLen, 0, 0); // RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING
            }

            if (m_nDisplayTabNumber == 0) { bIsMute = 1; }

            if (m_nDisplayTabNumber == 2) { bIsMute = 1; }

            return bIsMute;
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            uint i = 0;

            // USER INTERFACE PROGRAMMING (MAIN FORM)
            //
            System.Drawing.Size BorderSize = this.Size - this.ClientSize;

            this.Width = BorderSize.Width + 704;

            this.Height = BorderSize.Width + 480;

            for (i = 0; i < 4; i++)
            {
                m_cChannelControl_LIVE[i] = new MyChannelControl();

                m_cChannelControl_FILE[i] = new MyChannelControl();

                m_cChannelControl_H264_MAIN[i] = new MyChannelControl();

                m_cChannelControl_H264_SUB[i] = new MyChannelControl();

                m_cChannelControl_LIVE[i].Parent = this;

                m_cChannelControl_FILE[i].Parent = this;

                m_cChannelControl_H264_MAIN[i].Parent = this;

                m_cChannelControl_H264_SUB[i].Parent = this;

                if (i == 0)
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_H264_MAIN[i].Left = 0;
                    m_cChannelControl_H264_SUB[i].Left = 0;
                }

                if (i == 1)
                {
                    m_cChannelControl_LIVE[i].Left = 352;
                    m_cChannelControl_FILE[i].Left = 352;
                    m_cChannelControl_H264_MAIN[i].Left = 352;
                    m_cChannelControl_H264_SUB[i].Left = 352;
                }

                if (i == 2)
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_H264_MAIN[i].Left = 0;
                    m_cChannelControl_H264_SUB[i].Left = 0;
                }

                if (i == 3)
                {
                    m_cChannelControl_LIVE[i].Left = 352;
                    m_cChannelControl_FILE[i].Left = 352;
                    m_cChannelControl_H264_MAIN[i].Left = 352;
                    m_cChannelControl_H264_SUB[i].Left = 352;
                }

                if (i == 0)
                {
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_H264_MAIN[i].Top = 0;
                    m_cChannelControl_H264_SUB[i].Top = 0;
                }

                if (i == 1)
                {
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_H264_MAIN[i].Top = 0;
                    m_cChannelControl_H264_SUB[i].Top = 0;
                }

                if (i == 2)
                {
                    m_cChannelControl_LIVE[i].Top = 240;
                    m_cChannelControl_FILE[i].Top = 240;
                    m_cChannelControl_H264_MAIN[i].Top = 240;
                    m_cChannelControl_H264_SUB[i].Top = 240;
                }

                if (i == 3)
                {
                    m_cChannelControl_LIVE[i].Top = 240;
                    m_cChannelControl_FILE[i].Top = 240;
                    m_cChannelControl_H264_MAIN[i].Top = 240;
                    m_cChannelControl_H264_SUB[i].Top = 240;
                }

                m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_FILE[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_H264_MAIN[i].Size = new System.Drawing.Size(352, 240);
                m_cChannelControl_H264_SUB[i].Size = new System.Drawing.Size(352, 240);

                m_cChannelControl_LIVE[i].Visible = true;
                m_cChannelControl_FILE[i].Visible = false;
                m_cChannelControl_H264_MAIN[i].Visible = false;
                m_cChannelControl_H264_SUB[i].Visible = false;

                m_cChannelControl_LIVE[i].m_nChannelNumber = i + 0x1000000;
                m_cChannelControl_FILE[i].m_nChannelNumber = i + 0x2000000;
                m_cChannelControl_H264_MAIN[i].m_nChannelNumber = i + 0x4000000;
                m_cChannelControl_H264_SUB[i].m_nChannelNumber = i + 0x8000000;
            }

            for (i = 0; i < 4; i++)
            {
                m_hVideoDev[i] = 0xFFFFFFFF;

                m_hVideoMainEncoderDev[i] = 0xFFFFFFFF;

                m_hVideoSubEncoderDev[i] = 0xFFFFFFFF;

                m_hAudioDev[i] = 0xFFFFFFFF;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                m_nFileRendererRecordState[i] = 0;

                m_sFileRendererChangeSystemTime[i] = DateTime.Now;

                m_pFileRendererChangeDevName[i] = "";

                m_hFileSourceDev[i] = 0xFFFFFFFF;

                m_hNetworkRendererDev = 0xFFFFFFFF;

                m_nNetworkRendererStreamingState[i] = 0;
            }

            // CREATE CALLBACK FUNCTION
            // 
            m_pVideoBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_buffer);

            m_pAudioBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_audio_buffer);

            m_pVideoMainEncoderBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_main_encoder_buffer);

            m_pVideoSubEncoderBufferCB = new EXPORTS.PF_BUFFER_CALLBACK(on_process_video_sub_encoder_buffer);
            //

            m_nDisplayTabNumber = 0;

            // USER INTERFACE PROGRAMMING (SETUP CONTROL)
            //
            m_cSetupControl = new MySetupControl();            

            m_cSetupControl.m_pMainForm = this;

            m_cSetupControl.m_cFileManagerControl.m_pMainForm = this;

            BorderSize = m_cSetupControl.Size - m_cSetupControl.ClientSize;

            this.Top = this.Top - 75;

            m_cSetupControl.Top = this.Bottom + 5;

            m_cSetupControl.Left = this.Left - ((1248 - 704 - BorderSize.Width) / 2);

            m_cSetupControl.Width = 0;

            m_cSetupControl.Height = 0;

            m_cSetupControl.Visible = false;

            m_cSetupControl.Show();

            m_cSetupControl.Visible = false;

            HwInitialize();

            m_cSetupControl.Width = BorderSize.Width + 1248;

            m_cSetupControl.Height = BorderSize.Height + 25 * 12;

            m_cSetupControl.Visible = true; 
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            HwUninitialize();

            m_cSetupControl.Close();
        }

        public bool HwInitialize()
        {
            // GET DEVICE PARAMETERS FROM SETUP DIALOG
            //
            int std = 0;

            int[] cx = new int[8];

            int[] cy = new int[8];

            double[] fps = new double[8];

            int[] deinterlace = new int[8];

            int[] rcmode = new int[8];

            int[] bitrate = new int[8];

            int[] quality = new int[8];

            int[] gop = new int[8];

            int[] qpstep = new int[8];

            int[] peakbitrate = new int[8];

            int[] troughquality = new int[8];

            int i = 0;

            m_cSetupControl.GetStandardParameter(ref std);

            m_cSetupControl.GetResolutionParameter(ref cx, ref cy);

            m_cSetupControl.GetFrameRateParameter(ref fps);

            m_cSetupControl.GetDeinterlaceParameter(ref deinterlace);

            m_cSetupControl.GetRecordModeParameter(ref rcmode);

            m_cSetupControl.GetBitRateParameter(ref bitrate);

            m_cSetupControl.GetQualityParameter(ref quality);

            m_cSetupControl.GetGOPParameter(ref gop);

            m_cSetupControl.GetQPStepParameter(ref qpstep);

            m_cSetupControl.GetPeakBitRateParameter(ref peakbitrate);

            m_cSetupControl.GetTroughQualityParameter(ref troughquality);

            // INITIALIZE NETWORK RENDERERS (RTSP)
            //
            m_hNetworkRendererDev = 0xFFFFFFFF;

            string strNetworkRendererName = "Common Analog Network Renderer streams=4";

            m_hNetworkRendererDev = EXPORTS.AMESDK_CREATE(ref strNetworkRendererName, 0, 5, 0, null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

            if ((m_hNetworkRendererDev & 0x80000000) == 0x80000000) { m_hNetworkRendererDev = 0xFFFFFFFF; }

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0x34363248, (uint)cx[4], (uint)cy[4], 24, fps[4], (uint)(bitrate[4] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0x34363248, (uint)cx[5], (uint)cy[5], 24, fps[5], (uint)(bitrate[5] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0x34363248, (uint)cx[6], (uint)cy[6], 24, fps[6], (uint)(bitrate[6] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0x34363248, (uint)cx[7], (uint)cy[7], 24, fps[7], (uint)(bitrate[7] * 4));  // H264 = 0x34363248

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 0, 0, 1, 16, 8000, 1 * 16 * 8000 * 4); //  2012/03/20 MODIFY

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 1, 0, 1, 16, 8000, 1 * 16 * 8000 * 4); //  2012/03/20 MODIFY

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 2, 0, 1, 16, 8000, 1 * 16 * 8000 * 4); //  2012/03/20 MODIFY

            EXPORTS.AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT(m_hNetworkRendererDev, 3, 0, 1, 16, 8000, 1 * 16 * 8000 * 4); //  2012/03/20 MODIFY

            string strUserName = "root", strPassword = "root";

            EXPORTS.AMESDK_NETWORK_SET_USER_ACCOUNT(m_hNetworkRendererDev, ref strUserName, ref strPassword);

            EXPORTS.AMESDK_NETWORK_SET_STREAMING_PORT(m_hNetworkRendererDev, 554);

            // INITIALIZE FILE RENDERERS (AVI2.0)
            //
            for (i = 0; i < 4; i++)
            {
                DateTime system_time = DateTime.Now;

                string file_path;

                m_sFileRendererChangeSystemTime[i] = system_time;

                file_path = @"Common Analog File Renderer C:\SC2B0\CH" + (i + 1).ToString("D2") + "\\" +
                                                                    system_time.Year.ToString("D4") +
                                                                    system_time.Month.ToString("D2") +
                                                                    system_time.Day.ToString("D2") +
                                                                    system_time.Hour.ToString("D2") +
                                                                    system_time.Minute.ToString("D2") +
                                                                    system_time.Second.ToString("D2") + ".AVI";

                m_pFileRendererChangeDevName[i] = file_path;

                m_hFileRendererDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hFileRendererDev[0] = EXPORTS.AMESDK_CREATE(ref file_path, 0, 3, 0, null, 0); }

                if (i == 1) { m_hFileRendererDev[1] = EXPORTS.AMESDK_CREATE(ref file_path, 1, 3, 0, null, 0); }

                if (i == 2) { m_hFileRendererDev[2] = EXPORTS.AMESDK_CREATE(ref file_path, 2, 3, 0, null, 0); }

                if (i == 3) { m_hFileRendererDev[3] = EXPORTS.AMESDK_CREATE(ref file_path, 3, 3, 0, null, 0); }

                if ((m_hFileRendererDev[i] & 0x80000000) == 0x80000000) { m_hFileRendererDev[i] = 0xFFFFFFFF; }

                uint custom_flags = 0x00000000;

                EXPORTS.AMESDK_FILE_SET_VIDEO_STREAM_FORMAT(m_hFileRendererDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i], custom_flags); //H264 = 0x34363248

                EXPORTS.AMESDK_FILE_SET_AUDIO_STREAM_FORMAT(m_hFileRendererDev[i], 0x00000000, 1, 16, 8000); // PCM / MONO / 16BITS / 8000HZ
            }

            // INITIALIZE VIDEO STREAMS (YV12)
            //
            string strVideoChipName = "TW5864 PCI";

            for (i = 0; i < 4; i++)
            {
                m_hVideoDev[i] = 0xFFFFFFFF;

                if (i == 0) { m_hVideoDev[0] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 0, 0, (uint)m_cChannelControl_LIVE[0].Handle, m_pVideoBufferCB, 0, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 1) { m_hVideoDev[1] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 1, 0, (uint)m_cChannelControl_LIVE[1].Handle, m_pVideoBufferCB, 1, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 2) { m_hVideoDev[2] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 2, 0, (uint)m_cChannelControl_LIVE[2].Handle, m_pVideoBufferCB, 2, 0, null, 0, 0, null, 0, 0, null, 0); }

                if (i == 3) { m_hVideoDev[3] = EXPORTS.AMESDK_CREATE(ref strVideoChipName, 3, 0, (uint)m_cChannelControl_LIVE[3].Handle, m_pVideoBufferCB, 3, 0, null, 0, 0, null, 0, 0, null, 0); }

                if ((m_hVideoDev[i] & 0x80000000) == 0x80000000) { m_hVideoDev[i] = 0xFFFFFFFF; }
            }

            for (i = 0; i < 4; i++)
            {
                if ((std & 0x00000001) == 0x00000001)
                {
                    EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev[i], 0x00000001); // NTSC = 0x00000001

                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev[i], 0x32315659, 352, 240, 12, 29.97); // YV12 = &H32315659 // RESOLUTION = 352 × 240 × 29.97 / NTSC (PCI 33MHZ)

                    EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev[i], 0);
                }
                else
                {
                    EXPORTS.AMESDK_SET_STANDARD(m_hVideoDev[i], 0x00000010); // PAL = 0x00000010

                    EXPORTS.AMESDK_SET_FORMAT(m_hVideoDev[i], 0x32315659, 352, 240, 12, 25.0); // YV12 = &H32315659 // RESOLUTION = 352 × 288 × 25.00 / PALB (PCI 33MHZ)

                    EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoDev[i], 0);
                }
            }
            
            // INITIALIZE VIDEO MAIN ENCODER STREAMS (H.264)
           //
            string strVideoEncoderDev = "TW5864 PCI, Analog Encoder";

           for (i = 0; i < 4; i++)
           {
               m_hVideoMainEncoderDev[i] = 0xFFFFFFFF;

               if (i == 0) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 0, 0, (uint)m_cChannelControl_H264_MAIN[0].Handle, m_pVideoMainEncoderBufferCB, 0); }

               if (i == 1) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 1, 0, (uint)m_cChannelControl_H264_MAIN[1].Handle, m_pVideoMainEncoderBufferCB, 1); }

               if (i == 2) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 2, 0, (uint)m_cChannelControl_H264_MAIN[2].Handle, m_pVideoMainEncoderBufferCB, 2); }

               if (i == 3) { m_hVideoMainEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 3, 0, (uint)m_cChannelControl_H264_MAIN[3].Handle, m_pVideoMainEncoderBufferCB, 3); }

               if ((m_hVideoMainEncoderDev[i] & 0x80000000) == 0x80000000) { m_hVideoMainEncoderDev[i] = 0xFFFFFFFF; }

               EXPORTS.AMESDK_SET_STANDARD(m_hVideoMainEncoderDev[i], (uint)std);  // NTSC = &H00000001 / PAL = &H00000010

               EXPORTS.AMESDK_SET_FORMAT(m_hVideoMainEncoderDev[i], 0x34363248, (uint)cx[i], (uint)cy[i], 24, fps[i]);  // H264 = &H34363248

               EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoMainEncoderDev[i], (uint)deinterlace[i]);  // DISABLE = &H00000000 / BEST = &H00000007

               EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 3, (uint)rcmode[i]);  // RECORD MODE

               if (rcmode[i] == 0) // VBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 1, (uint)quality[i]);  // QUALITY

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 0, (uint)gop[i]); // GOP
               }

               if (rcmode[i] == 1) // CBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 4, (uint)bitrate[i]);  // BITRATE

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 0, (uint)gop[i]); // GOP

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 5, (uint)qpstep[i]); // QPSTEP
               }

               if (rcmode[i] == 2) // HBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 4, (uint)bitrate[i]); // BITRATE

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 1, (uint)quality[i]); // QUALITY

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 0, (uint)gop[i]); // GOP

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 5, (uint)qpstep[i]); // QPSTEP

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 6, (uint)peakbitrate[i]); // PEAK BITRATE

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoMainEncoderDev[i], 7, (uint)troughquality[i]); // TROUGH QUALITY
               }
           }

           // INITIALIZE VIDEO SUB ENCODER STREAMS (H.264)
           //
           for (i = 0; i < 4; i++)
           {
               m_hVideoSubEncoderDev[i] = 0xFFFFFFFF;

               if (i == 0) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 0, 0, (uint)m_cChannelControl_H264_SUB[0].Handle, m_pVideoSubEncoderBufferCB, 0); }

               if (i == 1) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 1, 0, (uint)m_cChannelControl_H264_SUB[1].Handle, m_pVideoSubEncoderBufferCB, 1); }

               if (i == 2) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 2, 0, (uint)m_cChannelControl_H264_SUB[2].Handle, m_pVideoSubEncoderBufferCB, 2); }

               if (i == 3) { m_hVideoSubEncoderDev[i] = EXPORTS.AMESDK_CREATE(ref strVideoEncoderDev, 3, 0, (uint)m_cChannelControl_H264_SUB[3].Handle, m_pVideoSubEncoderBufferCB, 3); }

               if ((m_hVideoSubEncoderDev[i] & 0x80000000) == 0x80000000) { m_hVideoSubEncoderDev[i] = 0xFFFFFFFF; }

               EXPORTS.AMESDK_SET_STANDARD(m_hVideoSubEncoderDev[i], (uint)std);  // NTSC = &H00000001 / PAL = &H00000010

               EXPORTS.AMESDK_SET_FORMAT(m_hVideoSubEncoderDev[i], 0x34363258, (uint)cx[i + 4], (uint)cy[i + 4], 24, fps[i + 4]); // X264 = &H34363258

               EXPORTS.AMESDK_SET_DEINTERLACE(m_hVideoSubEncoderDev[i], (uint)deinterlace[i + 4]); // DISABLE = &H00000000 / BEST = &H00000007

               EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 3, (uint)rcmode[i + 4]); // RECORD MODE

               if (rcmode[i + 4] == 0) // VBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 1, (uint)quality[i + 4]); // QUALITY (VBR)
               }

               if (rcmode[i + 4] == 1) // CBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 4, (uint)bitrate[i + 4]);  // BITRATE (CBR)
               }

               if (rcmode[i + 4] == 2) // HBR
               {
                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 1, (uint)quality[i + 4]); // QUALITY (HBR)

                   EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 4, (uint)bitrate[i + 4]); // BITRATE (HBR)
               }

               EXPORTS.AMESDK_SET_VIDEOCOMPRESSION_PROPERTY(m_hVideoSubEncoderDev[i], 0, (uint)gop[i + 4]); // GOP
           }

           // INITIALIZE AUDIO STREAMS (PCM)
           //
           string strAudioDev = "TW5864 PCI, Analog WaveIn";

           for (i = 0; i < 4; i++)
           {
               m_hAudioDev[i] = 0xFFFFFFFF;

               if (i == 0) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 0, 0, (uint)m_cChannelControl_LIVE[0].Handle, m_pAudioBufferCB, 0); }

               if (i == 1) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 1, 0, (uint)m_cChannelControl_LIVE[1].Handle, m_pAudioBufferCB, 1); }

               if (i == 2) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 2, 0, (uint)m_cChannelControl_LIVE[2].Handle, m_pAudioBufferCB, 2); }

               if (i == 3) { m_hAudioDev[i] = EXPORTS.AMESDK_CREATE(ref strAudioDev, 3, 0, (uint)m_cChannelControl_LIVE[3].Handle, m_pAudioBufferCB, 3); }

               if ((m_hAudioDev[i] & 0x80000000) == 0x80000000) { m_hAudioDev[i] = 0xFFFFFFFF; }

               uint n_audio_channels = 0;

               uint n_audio_bits_per_sample = 0;

               uint n_audio_samples_per_sec = 0;

               EXPORTS.AMESDK_SET_FORMAT(m_hAudioDev[i], 1, 16, 8000); // MONO / 16BITS / 8000HZ               

               EXPORTS.AMESDK_GET_FORMAT(m_hAudioDev[i], ref n_audio_channels, ref n_audio_bits_per_sample, ref n_audio_samples_per_sec);
           }

           // GET DEVICE SERIAL NUMBER
           //  
           EXPORTS.AMESDK_GET_CUSTOM_PROPERTY(m_hVideoDev[0], 0, ref m_nDeviceSerialNumber);

           //  RUN DEVICE
           //
           EXPORTS.AMESDK_RUN(m_hVideoDev[0]);

           EXPORTS.AMESDK_RUN(m_hVideoDev[1]);

           EXPORTS.AMESDK_RUN(m_hVideoDev[2]);

           EXPORTS.AMESDK_RUN(m_hVideoDev[3]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[0]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[1]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[2]);

           EXPORTS.AMESDK_RUN(m_hVideoMainEncoderDev[3]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[0]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[1]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[2]);

           EXPORTS.AMESDK_RUN(m_hVideoSubEncoderDev[3]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[0]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[1]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[2]);

           EXPORTS.AMESDK_RUN(m_hAudioDev[3]);

           EXPORTS.AMESDK_RUN(m_hNetworkRendererDev);

           System.Threading.Thread.Sleep(512);

           // STRAT RECORDING
           //
           m_bFileRendererChangeNotify[0] = false;

           m_bFileRendererChangeNotify[1] = false;

           m_bFileRendererChangeNotify[2] = false;

           m_bFileRendererChangeNotify[3] = false;

           m_nFileRendererRecordState[0] = 1; // ACQUIRE RECORDING

           m_nFileRendererRecordState[1] = 1; // ACQUIRE RECORDING

           m_nFileRendererRecordState[2] = 1; // ACQUIRE RECORDING

           m_nFileRendererRecordState[3] = 1; // ACQUIRE RECORDING

           if (m_hVideoSubEncoderDev[0] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[0] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

           if (m_hVideoSubEncoderDev[1] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[1] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

           if (m_hVideoSubEncoderDev[2] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[2] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

           if (m_hVideoSubEncoderDev[3] != 0xFFFFFFFF)
           {
               m_nNetworkRendererStreamingState[3] = 1; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
           }

            return true;
        }

        public bool HwUninitialize()
        {
            m_nNetworkRendererStreamingState[0] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[1] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[2] = 0; // STOP STREAMING

            m_nNetworkRendererStreamingState[3] = 0; // STOP STREAMING

            m_nFileRendererRecordState[0] = 0; // STOP RECORDING

            m_nFileRendererRecordState[1] = 0; // STOP RECORDING

            m_nFileRendererRecordState[2] = 0; // STOP RECORDING

            m_nFileRendererRecordState[3] = 0; // STOP RECORDING

            EXPORTS.AMESDK_STOP(m_hVideoDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoDev[3]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoMainEncoderDev[3]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[0]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[1]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[2]);

            EXPORTS.AMESDK_STOP(m_hVideoSubEncoderDev[3]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[0]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[1]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[2]);

            EXPORTS.AMESDK_STOP(m_hAudioDev[3]);

            uint i = 0;

            for (i = 0; i < 4; i++)
            {
                EXPORTS.AMESDK_DESTROY(m_hVideoDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hVideoMainEncoderDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hVideoSubEncoderDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hAudioDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hFileRendererDev[i]);

                EXPORTS.AMESDK_DESTROY(m_hFileSourceDev[i]);

                m_hVideoDev[i] = 0xFFFFFFFF;

                m_hVideoMainEncoderDev[i] = 0xFFFFFFFF;

                m_hVideoSubEncoderDev[i] = 0xFFFFFFFF;

                m_hAudioDev[i] = 0xFFFFFFFF;

                m_hFileRendererDev[i] = 0xFFFFFFFF;
            }

            EXPORTS.AMESDK_DESTROY(m_hNetworkRendererDev);

            m_hNetworkRendererDev = 0xFFFFFFFF;

            return true;
        }

        public void OnLButtonDown_ChannelControl(uint nChannelNumber)
        {
            if ((nChannelNumber & 0x1000000) == 0x1000000) // LIVE PATH
            {
                uint i = nChannelNumber - 0x1000000;

                if (m_cChannelControl_LIVE[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_LIVE[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_LIVE[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_LIVE[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_LIVE[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_LIVE[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_LIVE[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_LIVE[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_LIVE[i].Top = 240; }

                    m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_LIVE[0].Visible = true;
                    m_cChannelControl_LIVE[1].Visible = true;
                    m_cChannelControl_LIVE[2].Visible = true;
                    m_cChannelControl_LIVE[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev[i]);
                }
                else
                {
                    m_cChannelControl_LIVE[i].Left = 0;
                    m_cChannelControl_LIVE[i].Top = 0;
                    m_cChannelControl_LIVE[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_LIVE[0].Visible = false;
                    m_cChannelControl_LIVE[1].Visible = false;
                    m_cChannelControl_LIVE[2].Visible = false;
                    m_cChannelControl_LIVE[3].Visible = false;
                    m_cChannelControl_LIVE[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoDev[i]);
                }
            }

            if ((nChannelNumber & 0x2000000) == 0x2000000) // FILE STREAM PATH
            {
                uint i = nChannelNumber - 0x2000000;

                if (m_cChannelControl_FILE[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_FILE[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_FILE[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_FILE[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_FILE[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_FILE[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_FILE[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_FILE[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_FILE[i].Top = 240; }

                    m_cChannelControl_FILE[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_FILE[0].Visible = true;
                    m_cChannelControl_FILE[1].Visible = true;
                    m_cChannelControl_FILE[2].Visible = true;
                    m_cChannelControl_FILE[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev[i]);
                }
                else
                {
                    m_cChannelControl_FILE[i].Left = 0;
                    m_cChannelControl_FILE[i].Top = 0;
                    m_cChannelControl_FILE[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_FILE[0].Visible = false;
                    m_cChannelControl_FILE[1].Visible = false;
                    m_cChannelControl_FILE[2].Visible = false;
                    m_cChannelControl_FILE[3].Visible = false;
                    m_cChannelControl_FILE[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hFileSourceDev[i]);
                }
            }

            if ((nChannelNumber & 0x4000000) == 0x4000000) // H.264 MAIN.STREAM PATH
            {
                uint i = nChannelNumber - 0x4000000;

                if (m_cChannelControl_H264_MAIN[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_H264_MAIN[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_H264_MAIN[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_H264_MAIN[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_H264_MAIN[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_H264_MAIN[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_H264_MAIN[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_H264_MAIN[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_H264_MAIN[i].Top = 240; }

                    m_cChannelControl_H264_MAIN[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_H264_MAIN[0].Visible = true;
                    m_cChannelControl_H264_MAIN[1].Visible = true;
                    m_cChannelControl_H264_MAIN[2].Visible = true;
                    m_cChannelControl_H264_MAIN[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoMainEncoderDev[i]);
                }
                else
                {
                    m_cChannelControl_H264_MAIN[i].Left = 0;
                    m_cChannelControl_H264_MAIN[i].Top = 0;
                    m_cChannelControl_H264_MAIN[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_H264_MAIN[0].Visible = false;
                    m_cChannelControl_H264_MAIN[1].Visible = false;
                    m_cChannelControl_H264_MAIN[2].Visible = false;
                    m_cChannelControl_H264_MAIN[3].Visible = false;
                    m_cChannelControl_H264_MAIN[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoMainEncoderDev[i]);
                }
            }

            if ((nChannelNumber & 0x8000000) == 0x8000000) // H.264 SUB.STREAM PATH
            {
                uint i = nChannelNumber - 0x8000000;

                if (m_cChannelControl_H264_SUB[i].Size.Height > 360)
                {
                    if (i == 0) { m_cChannelControl_H264_SUB[i].Left = 0; }
                    if (i == 1) { m_cChannelControl_H264_SUB[i].Left = 352; }
                    if (i == 2) { m_cChannelControl_H264_SUB[i].Left = 0; }
                    if (i == 3) { m_cChannelControl_H264_SUB[i].Left = 352; }
                    if (i == 0) { m_cChannelControl_H264_SUB[i].Top = 0; }
                    if (i == 1) { m_cChannelControl_H264_SUB[i].Top = 0; }
                    if (i == 2) { m_cChannelControl_H264_SUB[i].Top = 240; }
                    if (i == 3) { m_cChannelControl_H264_SUB[i].Top = 240; }

                    m_cChannelControl_H264_SUB[i].Size = new System.Drawing.Size(352, 240);

                    m_cChannelControl_H264_SUB[0].Visible = true;
                    m_cChannelControl_H264_SUB[1].Visible = true;
                    m_cChannelControl_H264_SUB[2].Visible = true;
                    m_cChannelControl_H264_SUB[3].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoSubEncoderDev[i]);
                }
                else
                {
                    m_cChannelControl_H264_SUB[i].Left = 0;
                    m_cChannelControl_H264_SUB[i].Top = 0;
                    m_cChannelControl_H264_SUB[i].Size = new System.Drawing.Size(704, 480);

                    m_cChannelControl_H264_SUB[0].Visible = false;
                    m_cChannelControl_H264_SUB[1].Visible = false;
                    m_cChannelControl_H264_SUB[2].Visible = false;
                    m_cChannelControl_H264_SUB[3].Visible = false;
                    m_cChannelControl_H264_SUB[i].Visible = true;

                    EXPORTS.AMESDK_OTHER_REFRESH_DISPLAY_WINDOW(m_hVideoSubEncoderDev[i]);
                }
            }
        }

        public void OnCheckedChanged_RadioButton_SetupControl(uint nRadioButtonNumber)
        {
            if (nRadioButtonNumber == 0) // LIVE PATH
            {
                m_nDisplayTabNumber = 0;

                m_cChannelControl_LIVE[0].Visible = true;
                m_cChannelControl_LIVE[1].Visible = true;
                m_cChannelControl_LIVE[2].Visible = true;
                m_cChannelControl_LIVE[3].Visible = true;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;
                m_cChannelControl_H264_MAIN[0].Visible = false;
                m_cChannelControl_H264_MAIN[1].Visible = false;
                m_cChannelControl_H264_MAIN[2].Visible = false;
                m_cChannelControl_H264_MAIN[3].Visible = false;
                m_cChannelControl_H264_SUB[0].Visible = false;
                m_cChannelControl_H264_SUB[1].Visible = false;
                m_cChannelControl_H264_SUB[2].Visible = false;
                m_cChannelControl_H264_SUB[3].Visible = false;
            }

            if (nRadioButtonNumber == 1) // FILE STREAM PATH
            {
                m_nDisplayTabNumber = 1;

                m_cChannelControl_FILE[0].Visible = true;
                m_cChannelControl_FILE[1].Visible = true;
                m_cChannelControl_FILE[2].Visible = true;
                m_cChannelControl_FILE[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;
                m_cChannelControl_H264_MAIN[0].Visible = false;
                m_cChannelControl_H264_MAIN[1].Visible = false;
                m_cChannelControl_H264_MAIN[2].Visible = false;
                m_cChannelControl_H264_MAIN[3].Visible = false;
                m_cChannelControl_H264_SUB[0].Visible = false;
                m_cChannelControl_H264_SUB[1].Visible = false;
                m_cChannelControl_H264_SUB[2].Visible = false;
                m_cChannelControl_H264_SUB[3].Visible = false;
            }

            if (nRadioButtonNumber == 2) // H.264 MAIN.STREAM PATH
            {
                m_nDisplayTabNumber = 2;

                m_cChannelControl_H264_MAIN[0].Visible = true;
                m_cChannelControl_H264_MAIN[1].Visible = true;
                m_cChannelControl_H264_MAIN[2].Visible = true;
                m_cChannelControl_H264_MAIN[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;
                m_cChannelControl_H264_SUB[0].Visible = false;
                m_cChannelControl_H264_SUB[1].Visible = false;
                m_cChannelControl_H264_SUB[2].Visible = false;
                m_cChannelControl_H264_SUB[3].Visible = false;
            }

            if (nRadioButtonNumber == 3) // H.264 SUB.STREAM PATH
            {
                m_nDisplayTabNumber = 3;

                m_cChannelControl_H264_SUB[0].Visible = true;
                m_cChannelControl_H264_SUB[1].Visible = true;
                m_cChannelControl_H264_SUB[2].Visible = true;
                m_cChannelControl_H264_SUB[3].Visible = true;
                m_cChannelControl_LIVE[0].Visible = false;
                m_cChannelControl_LIVE[1].Visible = false;
                m_cChannelControl_LIVE[2].Visible = false;
                m_cChannelControl_LIVE[3].Visible = false;
                m_cChannelControl_FILE[0].Visible = false;
                m_cChannelControl_FILE[1].Visible = false;
                m_cChannelControl_FILE[2].Visible = false;
                m_cChannelControl_FILE[3].Visible = false;
                m_cChannelControl_H264_MAIN[0].Visible = false;
                m_cChannelControl_H264_MAIN[1].Visible = false;
                m_cChannelControl_H264_MAIN[2].Visible = false;
                m_cChannelControl_H264_MAIN[3].Visible = false;
            }
        }

        public bool OnFileSourceCreate_FileManagerWindow(uint nChannelNumber, ref EXPORTS.AMESDK_FILE_INFO pFileInfo)
        {
            if (m_hFileSourceDev[nChannelNumber] == 0xFFFFFFFF)
            {
                string pszFileSourceName = @"Common Analog File Source " + ByteArrayToString(pFileInfo.m_pszFileName);// +Encoding.ASCII.GetString(pFileInfo.m_pszFileName.ToString());

                m_hFileSourceDev[nChannelNumber] = EXPORTS.AMESDK_CREATE(ref pszFileSourceName, nChannelNumber, 2, (uint)m_cChannelControl_FILE[nChannelNumber].Handle.ToInt32(), null, 0, 0, null, 0, 0, null, 0, 0, null, 0);

                if ((m_hFileSourceDev[nChannelNumber] & 0x80000000) == 0x80000000)
                {
                    m_hFileSourceDev[nChannelNumber] = 0xFFFFFFFF;
                }
            }

            return true;
        }

        public uint OnFileSourceRun_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_RUN(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourcePause_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_PAUSE(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourceStop_FileManagerWindow(uint nChannelNumber)
        {
            return EXPORTS.AMESDK_STOP(m_hFileSourceDev[nChannelNumber]);
        }

        public uint OnFileSourceStep_FileManagerWindow(uint nChannelNumber, uint nSteps)
        {
            return EXPORTS.AMESDK_STEP(m_hFileSourceDev[nChannelNumber], nSteps);
        }

        public uint OnFileSourceGetVideoStreamData_FileManagerWindow(uint nChannelNumber, uint nSample, ref UInt64 pTimeStamp, ref uint pIsKeyFrame)
        {
            return EXPORTS.AMESDK_FILE_GET_VIDEO_STREAM_DATA(m_hFileSourceDev[nChannelNumber], nSample, ref pTimeStamp, ref pIsKeyFrame);
        }

        public uint OnFileSourceGetAudioStreamData_FileManagerWindow(uint nChannelNumber, uint nSample, ref UInt64 pTimeStamp)
        {
            return EXPORTS.AMESDK_FILE_GET_AUDIO_STREAM_DATA(m_hFileSourceDev[nChannelNumber], nSample, ref pTimeStamp);
        }

        public long OnFileSourceGetMediaLength_FileManagerWindow(uint nChannelNumber, uint dwTimeUnits)
        {
            long nLength = 0;

            EXPORTS.AMESDK_FILE_GET_MEDIA_LENGTH(m_hFileSourceDev[nChannelNumber], ref nLength, dwTimeUnits);

            return nLength;
        }

        public uint OnFileSourceSetMediaPosition_FileManagerWindow(uint nChannelNumber, long nPosition, uint dwTimeUnits)
        {
            return EXPORTS.AMESDK_FILE_SET_MEDIA_POSITION(m_hFileSourceDev[nChannelNumber], nPosition, dwTimeUnits);
        }

        public double OnFileSourceGetMediaPlaybackRate_FileManagerWindow(uint nChannelNumber)
        {
            double dRate = 0.0;

            EXPORTS.AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE(m_hFileSourceDev[nChannelNumber], ref dRate);

            return dRate;
        }

        public uint OnFileSourceSetMediaPlaybackRate_FileManagerWindow(uint nChannelNumber, double dRate)
        {
            return EXPORTS.AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE(m_hFileSourceDev[nChannelNumber], dRate);
        }

        public void OnFileSourceDestroy_FileManagerWindow(uint nChannelNumber)
        {
            if (m_hFileSourceDev[nChannelNumber] != 0xFFFFFFFF)
            {
                EXPORTS.AMESDK_DESTROY(m_hFileSourceDev[nChannelNumber]);

                m_hFileSourceDev[nChannelNumber] = 0xFFFFFFFF;
            }
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == 0x00000014) // 0x00000014 = WM_ERASEBKGND
            {
                return;
            }

            if (m.Msg == 0x400) // 0x400 = WM_USER (UPDATE FILE INFO LIST)
            {
                DateTime system_time = DateTime.Now;

                DateTime start_search_system_time = new DateTime(system_time.Year, system_time.Month, system_time.Day);

                DateTime stop_search_system_time = new DateTime(system_time.Year, system_time.Month, system_time.Day, 23, 59, 59, 999);

                UInt64 n_start_search_systemtime = (UInt64)start_search_system_time.ToFileTimeUtc();

                UInt64 n_stop_search_systemtime = (UInt64)stop_search_system_time.ToFileTimeUtc();

                UInt32 i = (UInt32)m.WParam;

                string psz_search_directory = @"C:\\SC2B0\\CH" + (i + 1).ToString("D2") + "\\";

                uint nSearchProgress = 0, nRepairProgress = 0;                

                EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_cSetupControl.m_cFileManagerControl.m_pFileInfoList[i], ref psz_search_directory, n_start_search_systemtime, n_stop_search_systemtime, 0, ref nSearchProgress, ref nRepairProgress); // 18446744073709551615 = &HFFFFFFFFFFFFFFFF                

                m_cSetupControl.m_cFileManagerControl.Invalidate(true);
            }

            base.WndProc(ref m);
        }

    }
}
